#RequireAdmin
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_Res_Comment=Diablo 2 IP Finder
#AutoIt3Wrapper_Res_Description=IP Finder
#AutoIt3Wrapper_Res_Fileversion=2.8.0.0
#AutoIt3Wrapper_Res_Language=1033
#AutoIt3Wrapper_Res_requestedExecutionLevel=requireAdministrator
#AutoIt3Wrapper_Run_Obfuscator=y
#Obfuscator_Parameters=/striponly
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#cs ----------------------------------------------------------------------------
 AutoIt Version: 3.3.6.1
 KissCloneHunter
 Based on CloneHunter 2.2 code
 Designed and created by Fuhrmanator@gmail.com, 2006-03-15
 Developed by PortalDeamon000 for latest Diablo 2 versions since 2008-09-30
 portal@portaldeamon.com
#ce ----------------------------------------------------------------------------

;;Autoit3 libraries
#include <Date.au3>
#include <GuiConstants.au3>
#include <GuiEdit.au3>
#include <ProgressConstants.au3>
#include <String.au3>
#include <WindowsConstants.au3>
#include <ListViewConstants.au3>
#include <TabConstants.au3>
#include <WinAPI.au3>
#include <Sound.au3>
#include <Array.au3>
#include <ComboConstants.au3>
#include <WindowsConstants.au3>
#include <ButtonConstants.au3>

;;Custom functions
#include <NomadMemory.au3>
#include <MinimizedMsg.au3>

Opt("TrayAutoPause",0)
Opt("GUICloseOnESC",0)

#Region startupvariables
Global Const $VersionInfo = 'KissCloneHunter 2.8'
Global Const $AdvClientFile = 'KCH2.8Client.exe'
Global Const $ReporterFile = 'KCHreporter.exe'

;make sure we are running as admin
if Not IsAdmin() Then
	MsgBox(48,$VersionInfo,"This program requires admin permissions to run correctly",5)
	Exit
EndIf

Global $GameCount = 0
Global $OFFSET_D2MULTI_SCREEN = 0x6F9EC138
Global $OFFSET_D2MULTI_IPADDRESS_ASCII = 0x6FA2B200
Global $OFFSET_D2CLIENT_LAST_CHAT_MSG = 0x101AA0
Global $OFFSET_D2CLIENT_GAME_PING = 0x108764
Global $OFFSET_D2CLIENT_GAMEINFO = 0x109738
Global $OFFSET_GAMENAME = 0x1B
Global $OFFSET_GAMEPASSWORD = 0x241
Global $OFFSET_D2CLIENT_ScreenSizeX = 0xF7034
Global $OFFSET_D2CLIENT_ScreenSizeY = 0xF7038

Global $MESSAGE_WALKS_ENGLISH = "\ADiablo\sWalks\sthe\sEarth"
Global $MESSAGE_WALKS_GERMAN = "\ADiablo\swandelt\sauf\sder\sErde"
Global $MESSAGE_WALKS_FRENCH = "\ADiablo\smarche\ssur\sle\smonde"
Global $MESSAGE_WALKS_POLISH = "\ADiablo\skroczy\spo\sZiemi"
Global $MESSAGE_WALKS_ITALIAN = "\ADiablo\scammina\ssulla\sTerra"
Global $MESSAGE_WALKS_SPANISH = "\ADiablo\scamina\ssobre\sla\sTierra"
Global $MESSAGE_SOJ_ENGLISH = "\A\d+\sStones\sof\sJordan\sSold\sto\sMerchants"
Global $MESSAGE_SOJ_GERMAN = "\A\d+\sSteine\svon\sJordan\san\sHndler\sverkauft"
Global $MESSAGE_SOJ_FRENCH = "\A\d+\sPierres\sde\sJordan\svendues\saux\smarchands"
Global $MESSAGE_SOJ_POLISH = "\A\d+\s.\sliczba\sKamieni\sjordana\ssprzedanych\skupcom"
Global $MESSAGE_SOJ_ITALIAN = "\A\d+\sPietre\sdi\sJordan\svendute\sai\smercanti"
Global $MESSAGE_SOJ_SPANISH = "\A\d+\sPiedras\sde\sJordan\svendidas\sa\slos\smercaderes"

Global $LOBBY_MAIN_CREATE_X			= 600
Global $LOBBY_MAIN_CREATE_Y			= 463
Global $LOBBY_MAIN_JOIN_X			= 706
Global $LOBBY_MAIN_JOIN_Y			= 463
Global $LOBBY_CREATE_HELL_X			= 706
Global $LOBBY_CREATE_HELL_Y			= 375
Global $LOBBY_CREATE_NORM_X			= 439
Global $LOBBY_CREATE_NORM_Y			= 375
Global $LOBBY_CREATE_X				= 706
Global $LOBBY_CREATE_Y				= 375

Global $changedip = 0
Global $oldptr1, $oldptr2, $oldmsg
Global $ingametimer
Global $d2clientdll = 0
;~ Global $d2multidll

Global $memoryhandle

;advanced only variables
Global $windowtitlearray, $winlist1, $winlist2, $winlist3, $totallabel, $profile, $profilecombo, $ipinput, $durationinput, $diffh, $diffn
GLobal $prefixinput, $passinput, $advGUI, $salecheckbox, $groupcombo, $groupcheckbox, $groupdetection, $reporter
Global $delaycombo1, $delaycombo2, $delaylabel1, $delaylabel2, $delaylabel3, $delayinput1, $delayinput2, $SaleSoundTimer, $WalkSoundTimer
Global $heavylog = 0
Global $silent = 0

$DebugForceFind = 0  ;; used for testing only

$UserUniqueGameName = 0
$UserUniqueGamePass = ""
$GameNumber = 0
$GameName = 0
$GamePass = 0
$CurrentIP = 0
$IPList = 0
$HuntSoundFile = @ScriptDir & '\diablo_hunt.wav'
$FoundSoundFile = @ScriptDir & '\tada.wav'
$DroppedSoundFile = @ScriptDir & '\dropped.mp3'
$SaleSoundFile = @ScriptDir & '\sale.wav'
$WalkSoundFile = @ScriptDir & '\walk.wav'
$WindowName = "Diablo II"
$radio_1 = ""
$radio_2 = ""
$input_1 = ""
$input_2 = ""
$input_3 = ""
$input_4 = ""
$input_5 = ""
$input_6 = ""

;; GUI positioning
$GUIWindowWidth = 250
$GUIWindowHeight = 510
$GUIWindowX = 600
$GUIWindowY = 0

$MSG_TimeToNextGame = "Time left:"

Dim $HuntedIPs[4] ;; gets redimensioned later, but we need its scope here

$GameDurationSeconds = 180
$AdjustedGameLengthSeconds = 0
$groupdetection = 0

;; Note - some users (including the author) experienced, at times,
;; frequent "failed to join game" errors after a new game is created.
;; Increasing the value below might help, but my experience shows
;; that even at 10 seconds, the problem can still occur.
;; If the delay is too small (e.g., 1 second), "failed to join game"
;; errors occur almost every time. There is likely another reason
;; for this error when delay before new game is higher, possibly
;; packet-loss on the local ISP, using a character that was in a game
;; that recently crashed, etc.
if IniRead("KCHadv.ini","Reserved","DelayBeforeNewGame","5") >= 1 Then
	$DelayBeforeNewGameSeconds = Int(IniRead("KCHadv.ini","Reserved","DelayBeforeNewGame","5"))
Else
	$DelayBeforeNewGameSeconds = 5
EndIf

;; generate a random letter (a-z) plus a 3-digit number (000-999) for game name prefix
$UserUniqueGameName = Chr(96 + Random(1, 26, 1)) & Random(0,9,1) & Random(0,9,1) & Random(0,9,1) & "-"
$AntiIdleDelayMS = 30 * 1000  ;; 30 secs
#EndRegion

#Region startupgui
; GUI - startup gui with update option
$startgui = GUICreate($VersionInfo, 250,215)
FileInstall("bg1.gif",@ScriptDir & "\background.gif",1)
GUICtrlCreatePic("background.gif",0,0,250,215)
FileDelete(@ScriptDir & "\background.gif")
GUICtrlSetState(-1,$GUI_DISABLE)
$advanced = GUICtrlCreateButton("Run KissCloneHunter",20,15,210,40)
GUICtrlSetFont(-1,11,600)
GUICtrlCreateLabel("",0,62,250,1)
GUICtrlSetBkColor(-1,0x999999)
GUICtrlCreateLabel("",0,63,250,1)
GUICtrlSetBkColor(-1,0x7F7F7F)
GUICtrlCreateLabel("",0,64,250,1)
GUICtrlSetBkColor(-1,0x666666)
GUICtrlCreateLabel("",0,65,250,1)
GUICtrlSetBkColor(-1,0x7F7F7F)
GUICtrlCreateLabel("",0,66,250,1)
GUICtrlSetBkColor(-1,0x999999)
$renamedup = GUICtrlCreateButton("Rename Duplicate Windows", 20, 73, 210, 26)
$helpbttn = GUICtrlCreateButton("Help - How to Use", 15, 107, 100, 26)
$updatebttn = GUICtrlCreateButton("Check For Updates", 135, 107, 100, 26)
$standardbttn = GuiCtrlCreateButton("Run KCH Basic", 70, 140, 100, 26)


$autoupdate = GUICtrlCreateCheckbox("Auto Check For Updates at Start",40,175,175,20)
if IniRead("KCHadv.ini","Reserved","AutoCheckUpdate","1") == "1" Then
	GUICtrlSetState ( -1, $GUI_CHECKED)
Else
	GUICtrlSetState ( -1, $GUI_UNCHECKED)
EndIf
$reporterbox = GUICtrlCreateCheckbox("Auto Report Sales and Walks",40,195,175,20)
$reporter = IniRead("KCHadv.ini","Reserved","Reporter","-1")
if $reporter == 1 Then
	GUICtrlSetState ( -1, $GUI_CHECKED)
Elseif $reporter == 0 Then
	GUICtrlSetState ( -1, $GUI_UNCHECKED)
Else
	$reporter = -1
	IniWrite("KCHadv.ini","Reserved","Reporter","-1")
EndIf
GUISetState(@SW_SHOW,$startgui)

if $reporter == -1 Then ;tell user about the reporter program
	Local $msgreturn = MsgBox(68,"Optional Reporter System","Do you wish to enable the Optional Soj Sale and Walk Reporter? Any sales KCH sees will be reporter to an online server for better soj tracking.  Do you wish to enable it?" & @CRLF & "If you change your mind you can adjust the setting from the starting menu.")
	if ($msgreturn == 6) Then ;Yes
		$reporter = 1
		IniWrite("KCHadv.ini","Reserved","Reporter","1")
		GUICtrlSetState ( $reporterbox, $GUI_CHECKED)
	ElseIf ($msgreturn == 7) Then ;No
		$reporter = 0
		IniWrite("KCHadv.ini","Reserved","Reporter","0")
		GUICtrlSetState ( $reporterbox, $GUI_UNCHECKED)
	EndIf
EndIf
if GUICtrlRead($autoupdate) == $GUI_CHECKED Then _Update(1) ;Start auto-check for update

; Startup GUI
While 1
	$msg = GUIGetMsg()
	Select
		Case $msg = $standardbttn
			if GUICtrlRead($autoupdate) == $GUI_CHECKED Then
				IniWrite("KCHadv.ini","Reserved","AutoCheckUpdate","1")
			Else
				IniWrite("KCHadv.ini","Reserved","AutoCheckUpdate","0")
			EndIf
			if GUICtrlRead($reporterbox) == $GUI_CHECKED Then
				IniWrite("KCHadv.ini","Reserved","Reporter","1")
				$reporter = 1
			Else
				IniWrite("KCHadv.ini","Reserved","Reporter","0")
				$reporter = 0
			EndIf
			GUIDelete($startgui)
            ExitLoop
		case $msg = $advanced
			if GUICtrlRead($autoupdate) == $GUI_CHECKED Then
				IniWrite("KCHadv.ini","Reserved","AutoCheckUpdate","1")
			Else
				IniWrite("KCHadv.ini","Reserved","AutoCheckUpdate","0")
			EndIf
			if GUICtrlRead($reporterbox) == $GUI_CHECKED Then
				IniWrite("KCHadv.ini","Reserved","Reporter","1")
				$reporter = 1
			Else
				IniWrite("KCHadv.ini","Reserved","Reporter","0")
				$reporter = 0
			EndIf
			GUIDelete($startgui)
            _advanced()
		Case $msg = $helpbttn
            ShellExecute("readme.txt")
		Case $msg = $updatebttn
			_Update()
		Case $msg = $renamedup
			_winrename()
		Case $msg = $GUI_EVENT_CLOSE
			if GUICtrlRead($autoupdate) == $GUI_CHECKED Then
				IniWrite("KCHadv.ini","Reserved","AutoCheckUpdate","1")
			Else
				IniWrite("KCHadv.ini","Reserved","AutoCheckUpdate","0")
			EndIf
			if GUICtrlRead($reporterbox) == $GUI_CHECKED Then
				IniWrite("KCHadv.ini","Reserved","Reporter","1")
			Else
				IniWrite("KCHadv.ini","Reserved","Reporter","0")
			EndIf
            Exit
	EndSelect
WEnd
#endregion

#Region standardKCH
;=====================================================================
;=====================================================================
;=====================================================================
;----------Standard/Basic KCH Version Main and Functions -----------
;=====================================================================
;=====================================================================
;=====================================================================


;; intro sound for cool (?) factor
Local $sound = _SoundOpen($HuntSoundFile)
_SoundPlay($sound)

;; option param = 16 so window can be moved if needed, smaller font (10 pt?)
;GUIWindowOn ( $VersionInfo, $VersionInfo & ' by Fuhrmanator, based on code by Snarg', $GUIWindowWidth, $GUIWindowHeight, $GUIWindowX, $GUIWindowY, 16, "", 10 )

; cell positioning of all new GUI components
AutoItSetOption("GUICoordMode", 2)
;~ AutoItSetOption("GUIOnEventMode", 1)

; GUI - make it resizable, and force it to top always
$maingui = GUICreate($VersionInfo, $GUIWindowWidth, $GUIWindowHeight, $GUIWindowX, $GUIWindowY, $WS_THICKFRAME + $WS_MINIMIZEBOX + $WS_SYSMENU + $WS_CAPTION);;, $WS_EX_TOPMOST + $WS_EX_TOOLWINDOW)

GUISetOnEvent($GUI_EVENT_CLOSE, "CLOSEClicked")

$WinNameLabel = GUICtrlCreateLabel("Window: ", 5, 3, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")

;Change IPs BUTTON
GUICtrlCreateButton("Change IPs:",-1,0,75)
GUICtrlSetOnEvent( -1, "ChangeIP")
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH )

$IPListLabel = GUICtrlCreateLabel("", 5, -1, $GUIWindowWidth - 85)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")

;Change Delay BUTTON
GUICtrlCreateButton("Change Delay:",5 - $GUIWindowWidth,0,90)
GUICtrlSetOnEvent( -1, "ChangeDelay")
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH )

$GameDurationLabel = GUICtrlCreateLabel("", 5, -1, $GUIWindowWidth - 100)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")

; Pause BUTTON
$PauseButton = GUICtrlCreateButton("Pause", 5 - $GUIWindowWidth, 0,$GUIWindowWidth - 10)
GUICtrlSetOnEvent( -1, "PauseButton")
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
$HuntPaused = 0
GUICtrlSetState( -1, $GUI_DISABLE)

; Hold Game/Abandon Game BUTTON
$HoldAbandonButton = GUICtrlCreateButton("Hold Game", -1, 0,$GUIWindowWidth - 10)
GUICtrlSetOnEvent( -1, "HoldAbandon")
$HoldGame = 0
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )

; Timer PROGRESS
$ProgressLabel = GUICtrlCreateLabel($MSG_TimeToNextGame, -1, 0, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
$Progress = GUICtrlCreateProgress(-1, 0, $GUIWindowWidth - 10, 20, $PBS_SMOOTH)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetData(-1, 0)

; INTERRUPT HUNT ON SOJ sales activity checkbox
$InterruptOnSalesCheckbox = GUICtrlCreateCheckbox( "Hold game on SoJ sale or Walk msg", -1, 0, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
if IniRead("KCHadv.ini","Reserved","Standard Stop on Sale","1") == "0" Then
	GUICtrlSetState ( -1, $GUI_UNCHECKED)
Else
	GUICtrlSetState ( -1, $GUI_CHECKED)
EndIf

; Log of messages
$LogText = GUICtrlCreateEdit($VersionInfo & @CRLF & ' by PortalDeamon000' & @CRLF & ' original version by Fuhrmanator' & @CRLF, -1, 0, $GUIWindowWidth - 5, $GUIWindowHeight - 165)
GUICtrlSetResizing($LogText, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKBOTTOM)

AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match

;;==================================================
;; Main code starts here
;;==================================================

VerifyDisplaySettings()

AskForAllInfo()

; Display main GUI window
AutoItSetOption("GUIOnEventMode", 1)
GUISetState(@SW_SHOW,$maingui)

;; must have this priv to read d2's memory
Local $privledge = _SetPrivilege ("SeDebugPrivilege", 1)
if $privledge == 0 Then
	MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to obtain process access rights.",5)
	Exit
EndIf
OnAutoItExitRegister("onexit")

GUICtrlSetData($WinNameLabel, "Window: " & $WindowName)
GUICtrlSetData($IPListLabel, $IPList)
GUICtrlSetData($GameDurationLabel, $GameDurationSeconds & " seconds")

if Not WinExists($WindowName) Then
	GUIDelete($maingui)
	MsgBox(48, "ERROR", "Window: " & $WindowName & " appears not to be running. Exiting...")
	Exit
EndIf

;open memory handle
$memoryhandle = _MemoryOpen(GetD2ProcessID())
If @error Then
	MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to open memory.",5)
	Exit
EndIf

WinSetState($WindowName,"",@SW_MINIMIZE)
Sleep(500)

;add the dll names to the memory so we only do this once
$d2clientdll = _ProcessGetLoadedModules(GetD2ProcessID(),"d2client.dll")
;~ $d2multidll = _ProcessGetLoadedModules(GetD2ProcessID(),"d2multi.dll")

if IsGameActive() Then
	$userResponse = MsgBox(6 + 32 + 262144, $VersionInfo & ": Notice", "KCH has noticed that you are currently in a game already. Do you want to anti-idle this game?" & @CRLF & "Press Continue to anti-idle, or Try Again to have the bot return to lobby and hunt")
    If $userResponse = 2 Then
    ;; user chose to cancel, exit...
        Exit
	ElseIf $userResponse = 11 Then
	;; user chose to camp this game
		getgamenamepass()
		HoldManualGame()
	ElseIf $userResponse = 10 Then
	;; user chose to return to lobby and hunt
		ExitGame()
		AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
		Sleep($DelayBeforeNewGameSeconds * 1000)
		VerifyLobbyScreenUp()
		_Main()
	EndIf

Else
	VerifyLobbyScreenUp()
EndIf

_Main()
Exit

Func _Main()
	while (1)

		CreateGame()
		Sleep(500)

		;; check to see if current game's IP is in list of hunted IPs
		getgamenamepass()
		$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
		If @error Then
			MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
			Exit
		EndIf
		AppendLineToLogText("Joined game IP: " & $CurrentIP)

		If IsIPFound($CurrentIP) Then
			AckHuntedIPFound()
		EndIf

		;==============================
		; prepare to wait in the game
		;==============================

		;; calculate the game time in seconds
		$AdjustedGameLengthSeconds = $GameDurationSeconds - $DelayBeforeNewGameSeconds

		UnPause()
		GUICtrlSetState($PauseButton, $GUI_ENABLE)

		;; wait in the game, displaying the time remaining and the progress bar
		For $sleepSecond = $AdjustedGameLengthSeconds To 0 Step - 0.5

			;;check if ingame and currentip is hunted
			if $changedip = 1 Then
				$changedip = 0
				if IsGameActive() Then
					If IsIPFound($CurrentIP) Then
						AckHuntedIPFound()
					EndIf
				EndIf
			EndIf

			$percentComplete = Int(100 * ($AdjustedGameLengthSeconds - $sleepSecond) / $AdjustedGameLengthSeconds)

			GUICtrlSetData($ProgressLabel, $MSG_TimeToNextGame & Int($sleepSecond) & " sec.")
			GUICtrlSetData($Progress, $percentComplete)

			Sleep(500)

			;; if the user pressed the pause button, the variable will be set
			While $HuntPaused = 1
				Sleep(500)
			WEnd
			if $HoldGame = 1 Then
				getgamenamepass()
				HoldManualGame()
			EndIf

			;; check for SOJ sales and/or Diablo Walks here,
			;; in case it happens while we're waiting for next game
			;; (that would be bad to ignore it!)
			Local $salemsg = GetLastChatMessage()
			If $salemsg <> "" Then
				Local $walkval = BitOR(StringRegExp($salemsg,$MESSAGE_WALKS_ENGLISH),StringRegExp($salemsg,$MESSAGE_WALKS_GERMAN),StringRegExp($salemsg,$MESSAGE_WALKS_FRENCH),StringRegExp($salemsg,$MESSAGE_WALKS_POLISH),StringRegExp($salemsg,$MESSAGE_WALKS_ITALIAN),StringRegExp($salemsg,$MESSAGE_WALKS_SPANISH))
				Local $saleval = BitOR(StringRegExp($salemsg,$MESSAGE_SOJ_ENGLISH),StringRegExp($salemsg,$MESSAGE_SOJ_GERMAN),StringRegExp($salemsg,$MESSAGE_SOJ_FRENCH),StringRegExp($salemsg,$MESSAGE_SOJ_POLISH),StringRegExp($salemsg,$MESSAGE_SOJ_ITALIAN),StringRegExp($salemsg,$MESSAGE_SOJ_SPANISH))
				If $walkval Then
					$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
					If @error Then
						MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
						Exit
					EndIf
					if TimerDiff($ingametimer) > 10000 Then ;wait at least 10 seconds to be sure this isn't the 'Walk' message shown on join
						Local $sound = _SoundOpen($WalkSoundFile)
						_SoundPlay($sound)
					;;;;;;;;REPORTER;;;;;
						if $reporter Then
							if FileExists($ReporterFile) Then
								Run($ReporterFile & " " & GetD2ProcessID())
							EndIf
						EndIf
					EndIf
					;;;;;;;;REPORTER;;;;;
					AppendLineToLogText($CurrentIP & "@WALK")
					WinFlash($maingui)
					;; only check for messages if user has requested
					If (GUICtrlRead($InterruptOnSalesCheckbox) = $GUI_CHECKED) Then InterruptHunt()
				ElseIf $saleval Then
					$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
					If @error Then
						MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
						Exit
					EndIf
					;;;;;;;;REPORTER;;;;;
					if TimerDiff($ingametimer) > 10000 Then
						Local $sound = _SoundOpen($SaleSoundFile)
						_SoundPlay($sound)
						if $reporter Then
							if FileExists($ReporterFile) Then
								Run($ReporterFile & " " & GetD2ProcessID())
							EndIf
						EndIf
					EndIf
					;;;;;;;;REPORTER;;;;;
					AppendLineToLogText($CurrentIP & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1) & " sojs")
					WinFlash($maingui)
					;; only check for messages if user has requested
					If (GUICtrlRead($InterruptOnSalesCheckbox) = $GUI_CHECKED) Then InterruptHunt()
				EndIf
			EndIf
		Next

		GUICtrlSetState($PauseButton, $GUI_DISABLE)
		GUICtrlSetData($Progress, 0)

		ExitGame()

		AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
		Sleep($DelayBeforeNewGameSeconds * 1000)

	WEnd
EndFunc

; =========== Subroutines ===============

Func VerifyDisplaySettings()

    If @DesktopWidth < 800 Or @DesktopHeight < 600 Then
        MsgBox(16 + 0, "Display settings incorrect", "Sorry. For this program to function properly, " & @CRLF & "your screen's resolution must be at least 800 x 600")
        Exit
    EndIf

EndFunc   ;==>VerifyDisplaySettings

; ===========================================
Func AskForAllInfo()
	; GUI - ask for info gui
	$infogui = GUICreate($VersionInfo,300,402)
	$label_0 = GUICtrlCreateLabel("Difficulty:",10,10,60,20)
	GUICtrlSetFont($label_0,10)
	$radio_1 = GUICtrlCreateRadio("Normal",0,-1,60,20)
	$radio_2 = GUICtrlCreateRadio("Hell",0,-1,50,20)
	if IniRead("KCHadv.ini","Reserved","Standard Difficulty","Hell") = "Normal" Then
		GUICtrlSetState($radio_1,$GUI_CHECKED)
	Else
		GUICtrlSetState($radio_2,$GUI_CHECKED)
	EndIf
	$label_1 = GUICtrlCreateLabel("Window Title:",-170,10,85,20)
	GUICtrlSetFont($label_1,10)
	$WindowName = IniRead("KCHadv.ini","Reserved","Standard Title","Diablo II")
	$input_1 = GUICtrlCreateInput($WindowName,0,-1,195,20)
	$label_2 = GUICtrlCreateLabel("Enter the name of your Diablo II window here. If using multiple windows, they must all have unique names.",-280,3,280,30)
	$label_3 = GUICtrlCreateLabel("IP List:",-1,5,50,20)
	GUICtrlSetFont($label_3,10)
	$input_2 = GUICtrlCreateInput(IniRead("KCHadv.ini","Reserved","Standard IP","66, 141"),0,-1,230,20)
	$label_4 = GUICtrlCreateLabel("Please enter a list of IPs to search for, separated by commas. Only enter the last part of an IP address, not the entire IP address.",-280,3,280,40)
	$label_5 = GUICtrlCreateLabel("Game Duration:",-1,5,95,20)
	GUICtrlSetFont($label_5,10)
	$GameDurationSeconds = IniRead("KCHadv.ini","Reserved","Standard Duration","180")
	$input_3 = GUICtrlCreateInput($GameDurationSeconds,0,-1,185,20)
	$label_6 = GUICtrlCreateLabel("Please enter how many seconds (at least 10) a game should last. Note: 180 seconds is generally a safe number to avoid getting IP banned after many tries.",-280,3,280,40)
	$label_7 = GUICtrlCreateLabel("Game Name Prefix:",-1,5,115,20)
	GUICtrlSetFont($label_7,10)
	if IniRead("KCHadv.ini","Reserved","Standard Prefix","(random)") == "(random)" Then
		;nothing
	Else
		$UserUniqueGameName = IniRead("KCHadv.ini","Reserved","Standard Prefix","(random)")
	EndIf
	$input_4 = GUICtrlCreateInput($UserUniqueGameName,0,-1,165,20)
	$label_8 = GUICtrlCreateLabel("Please enter a prefix for the games to use (should be unique)",-280,3,280,30)
	$label_9 = GUICtrlCreateLabel("Optional Game Password:",-1,5,155,20)
	GUICtrlSetFont($label_9,10)
	if IniRead("KCHadv.ini","Reserved","Standard Password","(default)") == "(default)" Then
		;nothing
	Else
		$UserUniqueGamePass = IniRead("KCHadv.ini","Reserved","Standard Password","(default)")
	EndIf
	$input_5 = GUICtrlCreateInput($UserUniqueGamePass,0,-1,125,20)
	$label_10 = GUICtrlCreateLabel("Entering a password here will set a custom password.  Leave blank for default game number as password.",-280,3,280,30)
	$nxt_button = GUICtrlCreateButton("Next -->",-280,10)
	GUISetState(@SW_SHOW,$infogui)

	While 1
		$msg = GUIGetMsg()
		Select
			Case $msg = $nxt_button
				$checkval = checkinfo()
				if $checkval = 0 Then
					GUIDelete($infogui)
					ExitLoop
				ElseIf $checkval = 1 Then
					GUICtrlSetState($input_1,$GUI_FOCUS)
				ElseIf $checkval = 2 Then
					GUICtrlSetState($input_2,$GUI_FOCUS)
				ElseIf $checkval = 3 Then
					GUICtrlSetState($input_3,$GUI_FOCUS)
				ElseIf $checkval = 4 Then
					GUICtrlSetState($input_4,$GUI_FOCUS)
				ElseIf $checkval = 5 Then
					GUICtrlSetState($input_5,$GUI_FOCUS)
				ElseIf $checkval = 6 Then
					GUICtrlSetState($input_6,$GUI_FOCUS)
				EndIf
			Case $msg = $GUI_EVENT_CLOSE
				Exit
		EndSelect
	WEnd

    AskToPrepareClient()

EndFunc

; ===========================================

Func checkinfo()
	if GUICtrlRead($input_1) = "" Then
		MsgBox(48,$VersionInfo,"Window Title must have a unique value!")
		Return 1
	EndIf
	$InputIPList = StringStripWS(GUICtrlRead($input_2), 8)  ;; strip all spaces
	$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
	if Not $SplitIPs[0] >= 1 Then
		MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
		Return 2
	EndIf
	if Not (GUICtrlRead($input_3) >= 10 And StringIsInt(GUICtrlRead($input_3))) Then
		MsgBox(48,$VersionInfo,"Game Duration must be an integer and greater than 10 seconds!")
		Return 3
	EndIf

	if GUICtrlRead($input_4) = "" Or StringLen(GUICtrlRead($input_4)) > 10 Then
		MsgBox(48,$VersionInfo,"Game Prefix must exist and cannot exceed 10 characters!")
		Return 4
	EndIf

	Local $val = GUICtrlRead($input_4)
	for $i=1 to StringLen($val)
		Local $val2 = StringMid($val,$i,1)
		if Not (StringIsAlNum($val2) or ($val2 = "-") or ($val2 = "_") or ($val2 = "'") or (($val2 = " ") And ($i > 1))) Then
			MsgBox(48,$VersionInfo,"Game Prefix cannot contain those invalid characters")
			Return 4
		EndIf
	Next

	if StringLen(GUICtrlRead($input_5)) > 10 Then
		MsgBox(48,$VersionInfo,"Game Password cannot exceed 10 characters!")
		Return 5
	EndIf

	Local $val = GUICtrlRead($input_5)
	for $i=1 to StringLen($val)
		Local $val2 = StringMid($val,$i,1)
		if Not (StringIsAlNum($val2) or ($val2 = "-") or ($val2 = "_") or ($val2 = "'") or (($val2 = " ") And ($i > 1))) Then
			MsgBox(48,$VersionInfo,"Game Password cannot contain those invalid characters")
			Return 5
		EndIf
	Next

	;; first element of array after Split is number of returned elements
    ReDim $HuntedIPs [$SplitIPs[0]]
    $IPList = ""
	For $r = 1 To UBound($SplitIPs) - 1
		if Not StringIsInt($SplitIPs[$r]) Then
			MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
			Return 2
		EndIf
		$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
        If $IPList = "" Then
            $IPList = $SplitIPs[$r]  ;; init to first split IP
        Else
            $IPList = $IPList & ", " & $SplitIPs[$r]
        EndIf
    Next
	$WindowName = GUICtrlRead($input_1)
	$GameDurationSeconds = GUICtrlRead($input_3)
	$UserUniqueGameName = GUICtrlRead($input_4)
	$UserUniqueGamePass = GUICtrlRead($input_5)
	if GUICtrlRead($radio_1) = $GUI_CHECKED Then
		$LOBBY_CREATE_X = $LOBBY_CREATE_NORM_X
		$LOBBY_CREATE_Y = $LOBBY_CREATE_NORM_Y
	EndIf
	if GUICtrlRead($radio_2) = $GUI_CHECKED Then
		$LOBBY_CREATE_X = $LOBBY_CREATE_HELL_X
		$LOBBY_CREATE_Y = $LOBBY_CREATE_HELL_Y
	EndIf
	Return 0
EndFunc

; ===========================================

Func AskToPrepareClient()

    $startResponse = MsgBox(1, $VersionInfo & ": Prepare D2 Client", "I will begin searching for the following IPs: " & $IPList & @CRLF & @CRLF & "Note: To stop me at any time, click my AutoIt icon in the system tray for a menu of options." & @CRLF & @CRLF & "Before continuing, make sure you have done the following:" & @CRLF & "1. Start Diablo in a separate window (-w option) and make sure the resolution is set to 800x600." & @CRLF & "2. Log in to your realm." & @CRLF & "3. Open a character that can create Hell-level games (make sure the Create button is on the screen).")

    If $startResponse = 2 Then  ;; cancel button
        Exit
    EndIf

EndFunc   ;==>AskToPrepareClient

; ===========================================

Func getgamenamepass()
	if $d2clientdll == 0 Then
		Sleep(100)
		$d2clientdll = _ProcessGetLoadedModules(GetD2ProcessID(),"d2client.dll")
		Sleep(100)
	EndIf
	$Gameinfo = _MemoryRead($d2clientdll + $OFFSET_D2CLIENT_GAMEINFO, $memoryhandle, 'dword')
	If @error Then
		MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
		Exit
	EndIf
	$GameinfoName = $Gameinfo + $OFFSET_GAMENAME
	$GameinfoPass = $Gameinfo + $OFFSET_GAMEPASSWORD
	$GameName = _MemoryRead($GameinfoName, $memoryhandle, 'char[24]')
	If @error Then
		MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
		Exit
	EndIf
	$GamePass = _MemoryRead($GameinfoPass, $memoryhandle, 'char[24]')
	If @error Then
		MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
		Exit
	EndIf
EndFunc

; ===========================================

Func ChangeIP()
	Local $val = 1
	$IPList_old = $IPList
	While $val = 1
		$val = 0
		Do
			$InputIPList = InputBox($VersionInfo & ": IP List", "Please enter a list of IPs to search for, separated by commas. Only enter the last part of an IP address, not the entire IP address.", $IPList, " M",Default,Default,Default,Default,30)

			If @error <> 0 Then
				$InputIPList = StringStripWS($IPList_old, 8)  ;; strip all spaces
				$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries

				ReDim $HuntedIPs [$SplitIPs[0]]
				$IPList = ""

				For $r = 1 To UBound($SplitIPs) - 1
					$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
					If $IPList = "" Then
						$IPList = $SplitIPs[$r]  ;; init to first split IP
					Else
						$IPList = $IPList & ", " & $SplitIPs[$r]
					EndIf

				Next
				Return
			EndIf

			$InputIPList = StringStripWS($InputIPList, 8)  ;; strip all spaces
			$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
		Until $SplitIPs[0] >= 1

		;; first element of array after Split is number of returned elements
		ReDim $HuntedIPs [$SplitIPs[0]]
		$IPList = ""

		For $r = 1 To UBound($SplitIPs) - 1
			if Not StringIsInt($SplitIPs[$r]) Then
				MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
				$val = 1
			EndIf
			$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
			If $IPList = "" Then
				$IPList = $SplitIPs[$r]  ;; init to first split IP
			Else
				$IPList = $IPList & ", " & $SplitIPs[$r]
			EndIf

		Next
	WEnd
	GUICtrlSetData($IPListLabel, $IPList)
	$changedip = 1
EndFunc

; ===========================================

Func ChangeDelay()
	Do
        $value = InputBox($VersionInfo & ": Game duration", "Please enter how many seconds (at least 10) a game should last. Note: 180 seconds is generally a safe number to avoid getting IP banned after many tries.", $GameDurationSeconds, " M",Default,Default,Default,Default,30)
		if @error = 1 Then
			Return
		EndIf
    Until (($value >= 10) AND (StringIsInt($value)))
	$GameDurationSeconds = $value
	GUICtrlSetData($GameDurationLabel, $GameDurationSeconds & " seconds")
EndFunc

; ===========================================

Func PauseButton()

    If $HuntPaused = 0 Then
        Pause()
    Else
        UnPause()
    EndIf

EndFunc   ;==>PauseButton

; ===========================================

Func Pause()

    $HuntPaused = 1
    GUICtrlSetData($PauseButton, "Resume")
    $PausedText = GUICtrlRead($ProgressLabel) & " (paused)"
    GUICtrlSetData($ProgressLabel, $PausedText)
    GUICtrlSetBkColor($Progress, 0xff0000)

EndFunc   ;==>Pause

; ===========================================

Func UnPause()

    $HuntPaused = 0
    GUICtrlSetData($PauseButton, "Pause")
    $PausedText = ""
    GUICtrlSetBkColor($Progress, 0xffffff)
    ;; no need to update the label - it will get updated once game resumes

EndFunc   ;==>UnPause

; ===========================================

Func HoldAbandon()
	If $HoldGame = 0 Then
		Hold()
	Else
		Abandon()
	EndIf

EndFunc

; ===========================================

Func Hold()
    UnPause()
    $HoldGame = 1
    GUICtrlSetData($HoldAbandonButton, "Abandon Game")

EndFunc

; ===========================================

Func Abandon()
    UnPause()
	GUICtrlSetState($HoldAbandonButton,$GUI_DISABLE)
    $HoldGame = 0
	AppendLineToLogText("Abandoning the game")
	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
    GUICtrlSetData($HoldAbandonButton, "Hold Game")
;~ 	ExitGame()
;~ 	AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
;~ 	Sleep($DelayBeforeNewGameSeconds * 1000)
;~ 	VerifyLobbyScreenUp()
EndFunc

; ===========================================

Func CloseClicked()

    Exit

EndFunc   ;==>CloseClicked

; ========================================

Func CreateGame()
	VerifyLobbyScreenUp()
    Do
        $GameCount = $GameCount + 1
        AppendLineToLogText( "Current try: " & $GameCount)
        ;; click Create button

		;; click "Join" button (to make sure "Create" will be active; it can be grayed out after create fails)
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y)
		Sleep(400)
		;; click "Create" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_CREATE_X, $LOBBY_MAIN_CREATE_Y)
		Sleep(400)
        ;; click Hell level button
        _MouseClickMinimized($WindowName, "left", $LOBBY_CREATE_X, $LOBBY_CREATE_Y)
		Sleep(400)

        ;; make game name and password
        $GameNumber = $GameNumber + 1
        $GameName = $UserUniqueGameName & $GameNumber
		if $UserUniqueGamePass = "" Then
			$GamePass = $GameNumber
		Else
			$GamePass = $UserUniqueGamePass
		EndIf
        AppendLineToLogText( "Trying to create " & $GameName & "//" & $GamePass)

		_SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')

    Until IsGameCreated() = 1

	$ingametimer = TimerInit()

    Return

EndFunc   ;==>CreateGame

; ========================================

;; logic is a bit strange here...

Func IsGameCreated()

    ; init a timer, so we can see how long this takes (for recovery)
    $TimerStart = TimerInit()

    ;; WaitForChangeInManaBall (1000, 7)  ;; milliseconds between checks, number of retries

    Local $RetryCount = 0
    Do
        If IsLobbyScreenUp() Then ;; wait until we leave the game lobby
			Sleep(1000)
		Else
			ExitLoop
		EndIf
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 15

    $RetryCount = 0
    Do
        If IsGameActive() Then
            Return 1
        EndIf
		If IsLobbyScreenUp() Then ExitLoop ;; returned to lobby (ftj)
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 60


    ; Assume now that Game creation has failed and try to recover
    ; we only deal with "failed to join game" errors, so we assume that happened.
    ; All we can do is wait the gameduration or 40 seconds (so the screen goes away), because a game was created that we couldn't join
    if $GameDurationSeconds < 40 Then
		$InitSecondsRemaining = (40 - Int(TimerDiff($TimerStart) / 1000))
	Else
		$InitSecondsRemaining = ($GameDurationSeconds - Int(TimerDiff($TimerStart) / 1000))
	EndIf
    AppendLineToLogText("Problem creating and joining game... Waiting " & $InitSecondsRemaining & " seconds, because game was likely created and I was unable to join it.")
	GUICtrlSetState($PauseButton, $GUI_ENABLE)
    For $sleepSecond = $InitSecondsRemaining To 0 Step - 0.5
        $percentComplete = Int(100 * ($InitSecondsRemaining - $sleepSecond) / $InitSecondsRemaining)


		;;check if ingame and currentip is hunted
		if $changedip = 1 Then
			$changedip = 0
			if IsGameActive() Then
				If IsIPFound($CurrentIP) Then
					AckHuntedIPFound()
				EndIf
			EndIf
		EndIf

		While $HuntPaused = 1
			Sleep(500)
		WEnd
		GUICtrlSetData($ProgressLabel, "Time before next game:" & Int($sleepSecond) & " sec.")
        GUICtrlSetData($Progress, $percentComplete)

		if $HoldGame = 1 Then
			getgamenamepass()
			HoldManualGame()
		EndIf

        Sleep(500)

    Next
    GUICtrlSetState($PauseButton, $GUI_DISABLE)
    VerifyLobbyScreenUp()

    Return 0

EndFunc   ;==>IsGameCreated

; ========================================

Func IsLobbyScreenUp()

    $Value = _MemoryRead ($OFFSET_D2MULTI_SCREEN, $memoryhandle, 'dword')

    If $Value <> 0 Then
        Return 1
    Else
        Return 0
    EndIf

EndFunc   ;==>IsLobbyScreenUp

; ========================================

Func VerifyLobbyScreenUp()

	;; wait to join lobby
	Local $retries = 0
	While ((Not IsLobbyScreenUp()) And $retries < 20)
		Sleep(500)
		$retries = $retries + 1
	WEnd

    If Not IsLobbyScreenUp() Then
        Do
            $userResponse = MsgBox(5 + 32 + 262144, $VersionInfo & ": Problem", "Either the Lobby Screen is not active in the Diablo II window, or the Create button is grayed out and I cannot create a game." & @CRLF & "Please make sure you've opened a character in Diablo and are waiting in the lobby screen, with the Create button present and enabled.")
            If $userResponse = 2 Then
                ;; user chose to cancel, exit...
                Exit
            EndIf
        Until IsLobbyScreenUp()
    Else
		GUICtrlSetState($HoldAbandonButton,$GUI_ENABLE)
        ;; everything is good, continue on
    EndIf

EndFunc   ;==>VerifyLobbyScreenUp

; ========================================

Func GetD2ProcessID()
    $ProcID = WinGetProcess($WindowName, "")
    If $ProcID = -1 Then
        MsgBox(16, "ERROR", "Diablo Game appears not to be running. Exiting...")
        Exit
    EndIf
    Return $ProcID
EndFunc   ;==>GetD2ProcessID

; ========================================

Func IsGameActive()

    ;; if game is active, then the game ping will be > 0

    $ping = ReadGamePing()
    If $ping > 0 Then
        Return 1
    Else
        Return 0
    EndIf

EndFunc   ;==>IsGameActive

; ========================================

Func ReadGamePing()

    Local $Value

    Local $ProcessID = GetD2ProcessID()
	if $d2clientdll == 0 Then
		Sleep(100)
		$d2clientdll = _ProcessGetLoadedModules(GetD2ProcessID(),"d2client.dll")
		Sleep(100)
	EndIf
	$value = _MemoryRead($d2clientdll + $OFFSET_D2CLIENT_GAME_PING, $memoryhandle, 'dword')
	If @error Then
		MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
		Exit
	EndIf

	Return $Value

EndFunc   ;==>ReadGamePing

; ========================================

Func IsIPFound($IP)
    ;; find last "." in IP address
    $lastDot = StringInStr($IP, ".", 0, 3)
    ;; find last part of IP address
    $lastPart = StringMid($IP, $lastDot + 1)

    ;; search for last part of IP in the HuntedIP array
    If $DebugForceFind Then
        $HuntedIPIsFound = 1
    Else
        $HuntedIPIsFound = 0
    EndIf

    For $r = 0 To UBound($HuntedIPs) - 1
        ;; MsgBox(4096, 'Comparing', "Comparing '" & $HuntedIPs[$r] & "' to '" & $lastPart & "'")
        If $HuntedIPs[$r] = $lastPart Then $HuntedIPIsFound = 1
    Next
    Return $HuntedIPIsFound
EndFunc   ;==>IsIPFound

; ========================================

Func ExitGame()
    $HoldGame = 0
	GUICtrlSetData($HoldAbandonButton, "Hold Game")
    AppendLineToLogText( "Trying to exit game...")
    ; ControlSetText ( $VersionInfo, "", "Static1", "Hunting IPs: " & $IPList & @CRLF & "Current try: " & $GameCount &@CRLF & "Trying to exit game...")

    ;; only try to exit if a game's not active

    If IsGameActive() Then
;~         _SendMinimized($WindowName, "{SPACE}{SPACE}{SPACE}")
;~         Sleep(100)

        _SendMinimized($WindowName, '{ESC}')
        Sleep(500)
		_SendMinimized($WindowName, '{UP}')
		Sleep(100)
		_SendMinimized($WindowName, '{ENTER}')

        ;; wait to disconnect from game
		Local $retries = 0
		While (IsGameActive() And $retries < 20)
			Sleep(500)
			$retries = $retries + 1
		WEnd
		if (Not IsGameActive()) Then
			;; wait to join lobby
			While ((Not IsLobbyScreenUp()) And $retries < 20)
				Sleep(500)
				$retries = $retries + 1
			WEnd
		EndIf

    Else
        AppendLineToLogText( "Game is already inactive; attempting to continue without exiting.")
    EndIf
	If IsGameActive() Then
		AppendLineToLogText( "Failed to exit game. trying alternate method")
		Local $coordx = 439
		Local $coordy = 259
		if $d2clientdll == 0 Then
			Sleep(100)
			$d2clientdll = _ProcessGetLoadedModules(GetD2ProcessID(),"d2client.dll")
			Sleep(100)
		EndIf
		Local $sizex = _MemoryRead($d2clientdll + $OFFSET_D2CLIENT_ScreenSizeX, $memoryhandle, 'dword')
		Local $sizey = _MemoryRead($d2clientdll + $OFFSET_D2CLIENT_ScreenSizeY, $memoryhandle, 'dword')
		If (($sizex == 640) And ($sizey == 480)) Then ;support for 640x480 clients
			$coordx = 320
			$coordy = 200
		EndIf
		_SendMinimized($WindowName, "{SPACE}{SPACE}")
        Sleep(100)

        _SendMinimized($WindowName, '{ESC}')
        Sleep(500)
        _MouseClickMinimized($WindowName, "left", $coordx, $coordy)  ;; coordinates of "Save and Exit Game" ;(300,200)
		Sleep(500)
		_MouseClickMinimized($WindowName, "left", $coordx, $coordy)  ;; coordinates of "Save and Exit Game"

        ;; wait to disconnect from game
		Local $retries = 0
		While (IsGameActive() And $retries < 20)
			Sleep(500)
			$retries = $retries + 1
		WEnd
		if (Not IsGameActive()) Then
			;; wait to join lobby
			While ((Not IsLobbyScreenUp()) And $retries < 20)
				Sleep(500)
				$retries = $retries + 1
			WEnd
		EndIf
	EndIf

    VerifyLobbyScreenUp()
    Return

EndFunc   ;==>ExitGame

; ========================================

Func AckHuntedIPFound()
    $HoldGame = 1
	GUICtrlSetData($HoldAbandonButton, "Abandon Game")

	$ingametimer = TimerInit()
	getgamenamepass()
	_loginfo("Found: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
    AppendLineToLogText("Hunted IP " & $CurrentIP & " has been found at")
	AppendLineToLogText("Game: " & $GameName & "//" & $GamePass)

    GUICtrlSetData($ProgressLabel, "Found IP " & $CurrentIP & "!")
    GUICtrlSetBkColor($ProgressLabel, 0x00FF00)

    ;; Give the user a chance to acknowledge the game has been found, NOT repeating the sound
	Local $sound = _SoundOpen($FoundSoundFile)
	_SoundPlay($sound)
	TrayTip("Success!!!", "Hunted IP " & $CurrentIP & " has been found!!!" & @CRLF & "Game name: " & $GameName & @CRLF & "Game password: " & $GamePass & @CRLF & "Currently anti-idling - will auto-rejoin if dropped.", "", 1)
    $ai = 0
	while IsGameActive()
		if $HoldGame = 0 Then
			ExitGame()
			AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
			Sleep($DelayBeforeNewGameSeconds * 1000)
			VerifyLobbyScreenUp()
			_Main()
		EndIf

		;; check for SOJ sales and/or Diablo Walks here and display them
		Local $salemsg = GetLastChatMessage()
		If $salemsg <> "" Then
			Local $walkval = BitOR(StringRegExp($salemsg,$MESSAGE_WALKS_ENGLISH),StringRegExp($salemsg,$MESSAGE_WALKS_GERMAN),StringRegExp($salemsg,$MESSAGE_WALKS_FRENCH),StringRegExp($salemsg,$MESSAGE_WALKS_POLISH),StringRegExp($salemsg,$MESSAGE_WALKS_ITALIAN),StringRegExp($salemsg,$MESSAGE_WALKS_SPANISH))
			Local $saleval = BitOR(StringRegExp($salemsg,$MESSAGE_SOJ_ENGLISH),StringRegExp($salemsg,$MESSAGE_SOJ_GERMAN),StringRegExp($salemsg,$MESSAGE_SOJ_FRENCH),StringRegExp($salemsg,$MESSAGE_SOJ_POLISH),StringRegExp($salemsg,$MESSAGE_SOJ_ITALIAN),StringRegExp($salemsg,$MESSAGE_SOJ_SPANISH))
			If $walkval Then
				$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
				If @error Then
					MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
					Exit
				EndIf
				if TimerDiff($ingametimer) > 10000 Then ;wait at least 10 seconds to be sure this isn't the 'Walk' message shown on join
					Local $sound = _SoundOpen($WalkSoundFile)
					_SoundPlay($sound)
					;;;;;;;;REPORTER;;;;;
					if $reporter Then
						if FileExists($ReporterFile) Then
							Run($ReporterFile & " " & GetD2ProcessID())
						EndIf
					EndIf
					;;;;;;;;REPORTER;;;;;
				EndIf
				AppendLineToLogText($CurrentIP & "@WALK")
			ElseIf $saleval Then
				$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
				If @error Then
					MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
					Exit
				EndIf
				;;;;;;;;REPORTER;;;;;
				if TimerDiff($ingametimer) > 10000 Then
					Local $sound = _SoundOpen($SaleSoundFile)
					_SoundPlay($sound)
					if $reporter Then
						if FileExists($ReporterFile) Then
							Run($ReporterFile & " " & GetD2ProcessID())
						EndIf
					EndIf
				EndIf
				;;;;;;;;REPORTER;;;;;
				AppendLineToLogText($CurrentIP & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1) & " sojs")
			EndIf
		EndIf

		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()
		EndIf

        Sleep(1000)
    WEnd

	;; Give the user a chance to acknowledge the game has been dropped
	Local $sound = _SoundOpen($DroppedSoundFile)
	_SoundPlay($sound)

    RejoinLostGameIP()

    Return

EndFunc   ;==>AckHuntedIPFound

; ========================================

Func RejoinLostGameIP()

	;; wait to disconnect from game
	Local $retries = 0
	While (IsGameActive() And $retries < 20)
		Sleep(500)
		$retries = $retries + 1
	WEnd
	;; wait for 'connection interrupted' to go away
	$retries = 0
	While ((Not IsLobbyScreenUp()) And $retries < 120)
		Sleep(500)
		$retries = $retries + 1
	WEnd

	Sleep(5000) ;;give the servers a few seconds so we dont instantly fail-to-join

	;; click "Join" button
	_MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y)
	Sleep(400)

	_loginfo("Rejoining: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
    AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)

    _SendMinimized($WindowName, $GameName & '{TAB}')
    Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
    _SendMinimized($WindowName, $GamePass)
    Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
    _SendMinimized($WindowName, '{ENTER}')

    $RetryCount = 0
    Do
        If IsGameActive() Then
			AppendLineToLogText( "Successfilly rejoined game!")
            AckHuntedIPFound()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30

	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
	$HoldGame = 0
    GUICtrlSetData($HoldAbandonButton, "Hold Game")
	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	_Main()

EndFunc

; ========================================

Func InterruptHunt()
    $HoldGame = 1
	GUICtrlSetData($HoldAbandonButton, "Abandon Game")

	$ingametimer = TimerInit()
	getgamenamepass()
	_loginfo("Sells: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
    AppendLineToLogText("Interrupting hunt because of detected activity on current server.")

    ;; adjust the progress bar and Pause button
    GUICtrlSetState($PauseButton, $GUI_DISABLE)
    GUICtrlSetData($ProgressLabel, "Interrupted - SoJ sales " & $CurrentIP)
    GUICtrlSetBkColor($ProgressLabel, 0x00FF00)
    GUICtrlSetData($Progress, 0)

    ;; Give the user a chance to acknowledge the game is being held, NOT repeating the sound
    Local $sound = _SoundOpen($FoundSoundFile)
	_SoundPlay($sound)
	TrayTip("Possible success!!!", "Chat messages indicate activity on " & $CurrentIP & @CRLF & "Game name: " & $GameName & @CRLF & "Game password: " & $GamePass & @CRLF & "Currently anti-idling - will auto-rejoin if dropped.", "", 1)
    $ai = 0
	while IsGameActive()
		if $HoldGame = 0 Then
			ExitGame()
			AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
			Sleep($DelayBeforeNewGameSeconds * 1000)
			VerifyLobbyScreenUp()
			_Main()
		EndIf

		;; check for SOJ sales and/or Diablo Walks here and display them
		Local $salemsg = GetLastChatMessage()
		If $salemsg <> "" Then
			Local $walkval = BitOR(StringRegExp($salemsg,$MESSAGE_WALKS_ENGLISH),StringRegExp($salemsg,$MESSAGE_WALKS_GERMAN),StringRegExp($salemsg,$MESSAGE_WALKS_FRENCH),StringRegExp($salemsg,$MESSAGE_WALKS_POLISH),StringRegExp($salemsg,$MESSAGE_WALKS_ITALIAN),StringRegExp($salemsg,$MESSAGE_WALKS_SPANISH))
			Local $saleval = BitOR(StringRegExp($salemsg,$MESSAGE_SOJ_ENGLISH),StringRegExp($salemsg,$MESSAGE_SOJ_GERMAN),StringRegExp($salemsg,$MESSAGE_SOJ_FRENCH),StringRegExp($salemsg,$MESSAGE_SOJ_POLISH),StringRegExp($salemsg,$MESSAGE_SOJ_ITALIAN),StringRegExp($salemsg,$MESSAGE_SOJ_SPANISH))
			If $walkval Then
				$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
				If @error Then
					MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
					Exit
				EndIf
				if TimerDiff($ingametimer) > 10000 Then ;wait at least 10 seconds to be sure this isn't the 'Walk' message shown on join
					Local $sound = _SoundOpen($WalkSoundFile)
					_SoundPlay($sound)
				;;;;;;;;REPORTER;;;;;
					if $reporter Then
						if FileExists($ReporterFile) Then
							Run($ReporterFile & " " & GetD2ProcessID())
						EndIf
					EndIf
				;;;;;;;;REPORTER;;;;;
				EndIf
				AppendLineToLogText($CurrentIP & "@WALK")
			ElseIf $saleval Then
				$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
				If @error Then
					MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
					Exit
				EndIf
				;;;;;;;;REPORTER;;;;;
				if TimerDiff($ingametimer) > 10000 Then
					Local $sound = _SoundOpen($SaleSoundFile)
					_SoundPlay($sound)
					if $reporter Then
						if FileExists($ReporterFile) Then
							Run($ReporterFile & " " & GetD2ProcessID())
						EndIf
					EndIf
				EndIf
				;;;;;;;;REPORTER;;;;;
				AppendLineToLogText($CurrentIP & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1) & " sojs")
			EndIf
		EndIf

		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()
		EndIf

        Sleep(1000)
    WEnd

	;; Give the user a chance to acknowledge the game has been dropped
	Local $sound = _SoundOpen($DroppedSoundFile)
	_SoundPlay($sound)

    RejoinLostGameInt()

    Return

EndFunc   ;==>InterruptHunt

; ============================================

Func RejoinLostGameInt()

		;; wait to disconnect from game
	Local $retries = 0
	While (IsGameActive() And $retries < 20)
		Sleep(500)
		$retries = $retries + 1
	WEnd
	;; wait for 'connection interrupted' to go away
	$retries = 0
	While ((Not IsLobbyScreenUp()) And $retries < 120)
		Sleep(500)
		$retries = $retries + 1
	WEnd

	;; click "Join" button
    _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y)
	Sleep(400)

	_loginfo("Rejoining: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
    AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)

    _SendMinimized($WindowName, $GameName & '{TAB}')
    Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
    _SendMinimized($WindowName, $GamePass)
    Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
    _SendMinimized($WindowName, '{ENTER}')

    $RetryCount = 0
    Do
        If IsGameActive() Then
			AppendLineToLogText( "Successfilly rejoined game!")
            InterruptHunt()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30

	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	$HoldGame = 0
    GUICtrlSetData($HoldAbandonButton, "Hold Game")
	_Main()

EndFunc

; ========================================

Func HoldManualGame()
    $HoldGame = 1
	GUICtrlSetData($HoldAbandonButton, "Abandon Game")

	$ingametimer = TimerInit()
	getgamenamepass()
    AppendLineToLogText("Holding game " & $GameName & "//" & $GamePass)
	$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
	If @error Then
		MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
		Exit
	EndIf
	AppendLineToLogText("Held game ip is: " & $CurrentIP)
	_loginfo("Holding game: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)

    ;; adjust the progress bar and Pause button
    GUICtrlSetState($PauseButton, $GUI_DISABLE)
    GUICtrlSetData($ProgressLabel, "Holding Ip " & $CurrentIP)
    GUICtrlSetBkColor($ProgressLabel, 0x00FF00)
    GUICtrlSetData($Progress, 0)

    ;; Give the user a chance to acknowledge the game is being held, no sound
    $ai = 0
	while IsGameActive()
		if $HoldGame = 0 Then
			ExitGame()
			AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
			Sleep($DelayBeforeNewGameSeconds * 1000)
			VerifyLobbyScreenUp()
			_Main()
		EndIf

		;; check for SOJ sales and/or Diablo Walks here and display them
		Local $salemsg = GetLastChatMessage()
		If $salemsg <> "" Then
			Local $walkval = BitOR(StringRegExp($salemsg,$MESSAGE_WALKS_ENGLISH),StringRegExp($salemsg,$MESSAGE_WALKS_GERMAN),StringRegExp($salemsg,$MESSAGE_WALKS_FRENCH),StringRegExp($salemsg,$MESSAGE_WALKS_POLISH),StringRegExp($salemsg,$MESSAGE_WALKS_ITALIAN),StringRegExp($salemsg,$MESSAGE_WALKS_SPANISH))
			Local $saleval = BitOR(StringRegExp($salemsg,$MESSAGE_SOJ_ENGLISH),StringRegExp($salemsg,$MESSAGE_SOJ_GERMAN),StringRegExp($salemsg,$MESSAGE_SOJ_FRENCH),StringRegExp($salemsg,$MESSAGE_SOJ_POLISH),StringRegExp($salemsg,$MESSAGE_SOJ_ITALIAN),StringRegExp($salemsg,$MESSAGE_SOJ_SPANISH))
			If $walkval Then
				$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
				If @error Then
					MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
					Exit
				EndIf
				if TimerDiff($ingametimer) > 10000 Then ;wait at least 10 seconds to be sure this isn't the 'Walk' message shown on join
					Local $sound = _SoundOpen($WalkSoundFile)
					_SoundPlay($sound)
					;;;;;;;;REPORTER;;;;;
					if $reporter Then
						if FileExists($ReporterFile) Then
							Run($ReporterFile & " " & GetD2ProcessID())
						EndIf
					EndIf
					;;;;;;;;REPORTER;;;;;
				EndIf
				AppendLineToLogText($CurrentIP & "@WALK")
			ElseIf $saleval Then
				$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
				If @error Then
					MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
					Exit
				EndIf
				;;;;;;;;REPORTER;;;;;
				if TimerDiff($ingametimer) > 10000 Then
					Local $sound = _SoundOpen($SaleSoundFile)
					_SoundPlay($sound)
					if $reporter Then
						if FileExists($ReporterFile) Then
							Run($ReporterFile & " " & GetD2ProcessID())
						EndIf
					EndIf
				EndIf
				;;;;;;;;REPORTER;;;;;
				AppendLineToLogText($CurrentIP & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1) & " sojs")
			EndIf
		EndIf

		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()

		EndIf

        Sleep(1000)
    WEnd

	;; Give the user a chance to acknowledge the game has been dropped
	Local $sound = _SoundOpen($DroppedSoundFile)
	_SoundPlay($sound)

    RejoinLostGameHold()

    Return

EndFunc   ;==>InterruptHunt

; ============================================

Func RejoinLostGameHold()

	;; wait to disconnect from game
	Local $retries = 0
	While (IsGameActive() And $retries < 20)
		Sleep(500)
		$retries = $retries + 1
	WEnd
	$retries = 0
	;; wait for 'connection interrupted' to go away
	While ((Not IsLobbyScreenUp()) And $retries < 120)
		Sleep(500)
		$retries = $retries + 1
	WEnd

    ;; click Create button

	;; click "Join" button
    _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y)
	Sleep(400)

	_loginfo("Rejoining: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
    AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)

    _SendMinimized($WindowName, $GameName & '{TAB}')
    Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
    _SendMinimized($WindowName, $GamePass)
    Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
    _SendMinimized($WindowName, '{ENTER}')

    $RetryCount = 0
    Do
        If IsGameActive() Then
			AppendLineToLogText( "Successfilly rejoined game!")
            HoldManualGame()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30

	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	$HoldGame = 0
    GUICtrlSetData($HoldAbandonButton, "Hold Game")
	_Main()

EndFunc

; ========================================

Func AntiIdle()

    If IsGameActive() Then
		;; anti-idle with random "vocal" message ("time to die!", etc.)
		_SendMinimized($WindowName, "{NUMPAD" & Random(0, 7, 1) & "}")
    Else

		;; Give the user a chance to acknowledge the game has been dropped
		Local $sound = _SoundOpen($DroppedSoundFile)
		_SoundPlay($sound)

		_loginfo("Game Dropped!: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
        AppendLineToLogText("Sorry. The game on the hunted IP " & $CurrentIP & " appears to have dropped")
		GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
;~         $userResponse = MsgBox(32, $VersionInfo & ": Problem", "Game " & $GameName & "//" & $GamePass & " appears to be lost (disconnected?). Check your Diablo II window.")
;~         Exit
    EndIf

EndFunc   ;==>AntiIdle

; ============================================

Func GetLastChatMessage()
	if $d2clientdll == 0 Then
		Sleep(100)
		$d2clientdll = _ProcessGetLoadedModules(GetD2ProcessID(),"d2client.dll")
		Sleep(100)
	EndIf

    Local $pointer1 = _MemoryRead ($d2clientdll + $OFFSET_D2CLIENT_LAST_CHAT_MSG, $memoryhandle, 'dword')
    Local $pointer2 = _MemoryRead ($pointer1, $memoryhandle, 'dword')
    Local $Temp = _MemoryReadWideString ($pointer2, $memoryhandle, 'ushort[396]')
	If ($oldptr1 == $pointer1) And ($oldptr2 == $pointer2) And ($oldmsg == $Temp) Then
		Return ""
	Else
		$oldptr1 = $pointer1
		$oldptr2 = $pointer2
		$oldmsg = $Temp
		Return $Temp
	EndIf
EndFunc   ;==>GetLastChatMessage

; ============================================

Func AppendLineToLogText($TextToAppend)
	if StringLen(GUICtrlRead($LogText)) >= 29800 Then ;check if edit box is close to 30,000 character limit and clear it if so
		GUICtrlSetData($LogText,_NowTime() & " " & "Character limit reached. Text Cleared")
	EndIf
	_GUICtrlEdit_AppendText($LogText,_NowTime() & " " & $TextToAppend & @CRLF)
EndFunc   ;==>AppendLineToLogText

;===============================================================================
;
; Function Name:  _SendMinimized()
;===============================================================================
Func _SendMinimized($Window, $keys)
    ;; note : testing with D2 shows that sending {ENTER} to open the chat screen
    ;;   requires that the D2 window be shown. Otherwise, all other keystrokes
    ;;   seem to be ingored, and the client stays in the chat mode.
	_SendMinimizedMessage(WinGetHandle($Window),$keys)

EndFunc   ;==>_SendMinimized

;========================================================

Func _ProcessGetLoadedModules($iPID,$dllname)
    Local Const $PROCESS_QUERY_INFORMATION=0x0400
    Local Const $PROCESS_VM_READ=0x0010
    Local $aCall, $hPsapi=DllOpen("Psapi.dll")
    Local $hProcess, $tModulesStruct
    $tModulesStruct=DllStructCreate("hwnd [200]")
    Local $SIZEOFHWND = DllStructGetSize($tModulesStruct)/200
    $hProcess=_WinAPI_OpenProcess(BitOR($PROCESS_QUERY_INFORMATION,$PROCESS_VM_READ),False,$iPID)
    If Not $hProcess Then Return SetError(1,0,-1)
    $aCall=DllCall($hPsapi,"int","EnumProcessModules","ptr",$hProcess,"ptr",DllStructGetPtr($tModulesStruct),"dword",DllStructGetSize($tModulesStruct),"dword*","")
    If $aCall[4]>DllStructGetSize($tModulesStruct) Then
        $tModulesStruct=DllStructCreate("hwnd ["&$aCall[4]/$SIZEOFHWND&"]")
        $aCall=DllCall($hPsapi,"int","EnumProcessModules","ptr",$hProcess,"ptr",DllStructGetPtr($tModulesStruct),"dword",$aCall[4],"dword*","")
    EndIf
    Local $aReturn[$aCall[4]/$SIZEOFHWND]
	Local $returnval = 0
    For $i=0 To Ubound($aReturn)-1
        $aCall=DllCall($hPsapi,"dword","GetModuleFileNameExW","ptr",$hProcess,"int",DllStructGetData($tModulesStruct,1,$i+1),"wstr","","dword",65536)
		if (StringRight($aCall[3]	,StringLen($dllname)+1) = "\" & $dllname) Then
;~ 			MsgBox(0,$i,$aCall[3] & @CRLF & DllStructGetData($tModulesStruct,1,$i+1))
			$returnval = DllStructGetData($tModulesStruct,1,$i+1)
		EndIf
        $aReturn[$i]=$aCall[3]
    Next
    _WinAPI_CloseHandle($hProcess)
    DllClose($hPsapi)
    Return $returnval
EndFunc

;;writes entry to a log file
Func _loginfo($message)
	if Not ($message == "") Then
		FileWriteLine("KCHlog.txt", _Now() & " " & $WindowName & ": " & $message)
	EndIf
EndFunc

;; renames dupicate D2 windows
Func _winrename()
	Local $winarray[100][2]
	Local $winissue[100][3]
	$winarray = _combwin()
	$winissue[0][0] = 0

	for $i = 1 to $winarray[0][0]
		for $j = 1 to $winarray[0][0]
			if Not($i == $j) Then ;only check if not checking the same value
				if $winarray[$i][0] == $winarray[$j][0] Then ;matching value
					;save trouble window information into a new array
					for $k = 1 to UBound($winissue)-1
						if $winissue[$k][1] == "" Then ;save into a blank spot
							$winissue[0][0] = $winissue[0][0] + 1 ;increase total num of values
							$winissue[$k][0] = $winarray[$i][0]
							$winissue[$k][1] = $winarray[$i][1]
							ExitLoop 2
						EndIf
					Next

				EndIf
			EndIf
		Next
	Next

	;check winissue array for duplicates and link them together
	if $winissue[0][0] >= 1 Then ;check if any window name exists multiple times
		for $i = 1 to $winissue[0][0]
			for $j = 1 to $winissue[0][0]
				if Not($i == $j) Then ;only check if not checking the same value
					if $winissue[$i][0] == $winissue[$j][0] Then ;check if titles are the same
						$winissue[$i][2] = $winissue[$i][2] & $j & " " ;save that these have the same values
					EndIf
				EndIf
			Next
		Next

;~ 		_ArrayDisplay($winarray)
;~ 		_ArrayDisplay($winissue)
		;tell the not first duplicate to change title
		Local $tempstring
		for $i = 1 to $winissue[0][0]
			if Not($winissue[$i][1] == "") Then ;dont check values we have already cleared
				$tempstring = StringSplit($winissue[$i][2]," ")
				$winissue[$i][0] = ""
				$winissue[$i][1] = ""
				$winissue[$i][2] = ""
				for $j = 1 to ($tempstring[0] -1)
					if Not($winissue[$tempstring[$j]][1] == "") Then ;dont check values we have already cleared
						$currentwinlist = _combwin() ;get current win list
						$titlevar = ""
						if (Stringleft($winissue[$tempstring[$j]][0],4) == "[#] ") AND (Stringright($winissue[$tempstring[$j]][0],4) == " [#]") then
							$titlevar = StringTrimRight(StringTrimLeft($winissue[$tempstring[$j]][0],4),4)
						endif
						if $titlevar Then ;if sandboxed window
							for $k = 1 to 99
								$taken = 0
								for $l = 1 to $currentwinlist[0][0]
									if ("[#] " & $titlevar & "-" & $k & " [#]") == $currentwinlist[$l][0] Then ;check if new title already taken
										$taken = 1
										ExitLoop
									EndIf
								Next
								if $taken == 0 Then ;only set if new title is not taken
									WinSetTitle($winissue[$tempstring[$j]][1],"", $titlevar & "-" & $k)
									$winissue[$tempstring[$j]][0] = ""
									$winissue[$tempstring[$j]][1] = ""
									$winissue[$tempstring[$j]][2] = ""
;~ 									_ArrayDisplay($winissue)
									ExitLoop ;go onto next duplicate window
								EndIf
							Next
						Else ;if non-sandboxed window
							for $k = 1 to 99
								$taken = 0
								for $l = 1 to $currentwinlist[0][0]
									if ($winissue[$tempstring[$j]][0] & "-" & $k) == $currentwinlist[$l][0] Then ;check if new title already taken
										$taken = 1
										ExitLoop
									EndIf
								Next
								if $taken == 0 Then ;only set if new title is not taken
;~ 									MsgBox(0,"kch title", ":" & $tempstring[$j] & ":")
									WinSetTitle($winissue[$tempstring[$j]][1],"", $winissue[$tempstring[$j]][0] & "-" & $k)
									$winissue[$tempstring[$j]][0] = ""
									$winissue[$tempstring[$j]][1] = ""
									$winissue[$tempstring[$j]][2] = ""
;~ 									_ArrayDisplay($winissue)
									ExitLoop ;go onto next duplicate window
								EndIf
							Next
						EndIf
					EndIf
				Next
			EndIf
		Next
	EndIf

	MsgBox(0,$VersionInfo,"All duplicate Diablo II windows have been renamed")
EndFunc

;; called by _winrename(), will combine the regular and sandboxed window arrays
Func _combwin()

	AutoItSetOption("WinTitleMatchMode", 4)  ;; classname
	Local $winarray1, $winarray2
	$winarray1 = WinList("classname=Diablo II")
	$winarray2 = WinList("[REGEXPCLASS:\ASandbox:([A-Za-z0-9]+):Diablo II\Z]") ;scan for sandboxie D2 windows
	Local $winarraycom[100][2]
	AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match

	;; combine regular and sandboxed windows
	$winarraycom[0][0] = 0
	for $i = 1 to $winarray1[0][0]
		for $k = 1 to UBound($winarraycom)-1
			if $winarraycom[$k][1] == "" Then
				$winarraycom[0][0] = $winarraycom[0][0] + 1
				$winarraycom[$k][0] = $winarray1[$i][0]
				$winarraycom[$k][1] = $winarray1[$i][1]
				ExitLoop
			EndIf
		Next
	Next
	for $i = 1 to $winarray2[0][0]
		for $k = 1 to UBound($winarraycom)-1
			if $winarraycom[$k][1] == "" Then
				$winarraycom[0][0] = $winarraycom[0][0] + 1
				$winarraycom[$k][0] = $winarray2[$i][0]
				$winarraycom[$k][1] = $winarray2[$i][1]
				ExitLoop
			EndIf
		Next
	Next

	Return $winarraycom

EndFunc

;=====================================================================
; by PortalDeamon000
Func _Update($silent = 0)
	FileDelete(@ScriptDir & "\version.dat")
	InetGet("http://www.portaldeamon.com/VersionKCH.txt", @ScriptDir & "\version.dat", 1, 0)
	$version = FileRead(@ScriptDir & "\version.dat")
	Local $size = FileGetSize(@ScriptDir & "\version.dat")
	FileDelete(@ScriptDir & "\version.dat")
	if ($size < 3) Or ($size > 30) Then
		if $silent == 0 Then MsgBox(48, "Updater", "ERROR!" & @CRLF & "Update Site Not Found")
		Return
	EndIf
	if $version = $VersionInfo Then
		if $silent == 0 Then MsgBox(0, "Updater", "No New Updates")
		Return
	Else
		$return = MsgBox(49, $VersionInfo, $version & " is avaiable for download." & @CRLF & "Click OK to download." )
		if $return = 1 Then
;~ 			ShellExecute("http://www.portaldeamon.com/kch_latest_release.zip")
			Local $var
			$var = FileSaveDialog("Select Save Location",@ScriptDir,"All Files (*.*)|Zipped Files (*.zip)",18,"kch_latest_release.zip")
			if @error Then Return
			Local $filesize = Int(InetGetSize("http://www.portaldeamon.com/kch_latest_release.zip",1))
			Local $download = InetGet("http://www.portaldeamon.com/kch_latest_release.zip",$var,1,1)
			ProgressOn($version,"Downloading...","0%")
			Local $percent
			Do
				Sleep(50)
				$percent = Int(InetGetInfo($download,0)/$filesize*100)
				ProgressSet($percent,$percent & "%")
			Until InetGetInfo($download,2)
						ProgressOff()
			if InetGetInfo($download,0) >= $filesize Then
				InetClose($download)
				MsgBox(0,$version & " Download", $version & " has finished downloading",3)
				ShellExecute(StringTrimRight($var,StringLen("kch_latest_release.zip")))
			Else
				InetClose($download)
				MsgBox(0,$version & " Download", "Download Appears to have Failed!")
			EndIf
		EndIf
		Return
	EndIf
EndFunc

;called when kch closes
Func onexit()
	_MemoryClose($memoryhandle) ;make sure we close the process handle
EndFunc

#EndRegion

#Region advancedKCH
;=====================================================================
;=====================================================================
;=====================================================================
;----------Advanced KCH Version Main and Functions -------------------
;=====================================================================
;=====================================================================
;=====================================================================
Func _advanced()

	if Not FileExists($AdvClientFile) Then ;;make sure Client File Exists
		MsgBox(0,$VersionInfo,"Error, " & $AdvClientFile & " is not detected. Exiting")
		_exitadv()
	EndIf

	$SaleSoundTimer = TimerInit() ;setup timer so we only play a max of every 3 seconds
	$WalkSoundTimer = TimerInit() ;setup timer so we only play a max of every 3 seconds
	;; intro sound for cool (?) factor
	Local $sound = _SoundOpen($HuntSoundFile)
	_SoundPlay($sound)

	AutoItSetOption("TrayIconHide",1)
	AutoItSetOption("GUICoordMode",1)
	AutoItSetOption("GUIOnEventMode", 1)
	AutoItSetOption("WinDetectHiddenText", 1)
	AutoItSetOption("WinTitleMatchMode", 4)  ;; classname
	$winarray1 = WinList("classname=Diablo II")
	AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match

	Global $windowtitlearray[100][21]

#cs ;;Array Info
0 = Diablo Title
1 = Diablo Handle
2 = Client PID
3 = ControlID
4 = Tab

5 = Status
6 = Current Game
7 = Current IP
8 = Success Rate

9 = Hunted IP(s)
10 = Delay
11 = Prefix
12 = Pass
13 = Difficulty
14 = Sandbox
15 = Group
16 = Stop on Sale
17 = Delay after Games
18 = Delay after Time
19 = Delay Amount
20 = GroupGameLimit
#ce

	$windowtitlearray[0][0] = $winarray1[0][0] ;;total number of windows

	$advGUI = GUICreate($VersionInfo & " Advanced",700, 400, 250, 200, $WS_THICKFRAME + $WS_MINIMIZEBOX + $WS_SYSMENU + $WS_CAPTION)
	GUISetOnEvent($GUI_EVENT_CLOSE, "_exitadv")
	GUICtrlCreateButton("Counts Webpage",339,3)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent(-1, "_opencounts")
	GUICtrlCreateButton("Open Log",435,3)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent(-1, "_openlog")
	GUICtrlCreateButton("Check For Updates", 495, 3)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent(-1, "_Update")
	GUICtrlCreateButton("Open Readme",600,3)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent(-1, "_openreadme")
	$tab = GUICtrlCreateTab(10,10,680,380)
	GUICtrlSetResizing(-1,$GUI_DOCKLEFT + $GUI_DOCKRIGHT + $GUI_DOCKTOP + $GUI_DOCKBOTTOM)

	;;Tab 1 Controls
	$tab1 = GUICtrlCreateTabItem("Startup - Settings")
	$totallabel = GUICtrlCreateLabel("Detected Windows: " & $windowtitlearray[0][0] & @crlf & "Not Hunting: " & $windowtitlearray[0][0],50,50)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE)
	GUICtrlCreateButton("Refresh",170,50,60,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_liststartwindows")
	$winlist1 = GUICtrlCreateListView("Window         |Handle     ",40,80,195,300,$LVS_SHOWSELALWAYS,BitOR($LVS_EX_GRIDLINES,$LVS_EX_CHECKBOXES))
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKBOTTOM + $GUI_DOCKLEFT + $GUI_DOCKRIGHT)

	GUICtrlCreateLabel("Select Saved Profile:", 270, 50, 120,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	Local $profilearray = IniReadSectionNames("KCHadv.ini")
	if not @error Then
		Local $string
		$profile = ""
		for $i = 1 to $profilearray[0]
			if Not ($profilearray[$i] == "Reserved") Then
				if $profile == "" Then
					$profile = $profilearray[$i]
				Else
					$string = $string & $profilearray[$i] & "|"
				EndIf
			EndIf
		Next
	EndIf
	$profilecombo = GUICtrlCreateCombo($profile,395,50,165,420,$CBS_DROPDOWNLIST + $CBS_AUTOHSCROLL + $WS_VSCROLL + $WS_TABSTOP)
	GUICtrlSetData(-1,StringTrimRight($string,1))
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlCreateLabel("Difficulty:",270,80,60,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	$diffn = GUICtrlCreateRadio("Normal",330,80,60,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	$diffh = GUICtrlCreateRadio("Hell",395,80,50,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	if IniRead("KCHadv.ini",$profile,"Difficulty","Hell") == "Normal" Then
		GUICtrlSetState($diffn,$GUI_CHECKED)
	Else
		GUICtrlSetState($diffh,$GUI_CHECKED)
	EndIf
	GUICtrlCreateLabel("Group:",455,80,50,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	$groupcombo = GUICtrlCreateCombo("",500,80,60,420,$CBS_DROPDOWNLIST + $CBS_AUTOHSCROLL + $WS_VSCROLL + $WS_TABSTOP)
	GUICtrlSetData(-1,"1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20",IniRead("KCHadv.ini",$profile,"Group","1"))
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	$salecheckbox = GUICtrlCreateCheckbox(" Stop on Sale/Walk",270,102,130,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	if IniRead("KCHadv.ini",$profile,"Stop on Sale","1") == 1 Then GUICtrlSetState(-1,$GUI_CHECKED)
	$groupcheckbox = GUICtrlCreateCheckbox(" Limit group to 1 game/server",450,102,190,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	if IniRead("KCHadv.ini",$profile,"GroupGameLimit","0") == 1 Then GUICtrlSetState(-1,$GUI_CHECKED)
	GUICtrlCreateLabel("IP List:",270,124,50,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	$ipinput = GUICtrlCreateInput(IniRead("KCHadv.ini",$profile,"Hunted Ip","66, 141"),330,127,230,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlCreateLabel("Game Duration:",270,152,95,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	$durationinput = GUICtrlCreateInput(IniRead("KCHadv.ini",$profile,"Duration",180),375,152,185,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlCreateLabel("Game Name Prefix:",270,177,115,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	$prefixinput = GUICtrlCreateInput(IniRead("KCHadv.ini",$profile,"Prefix","(random)"),395,177,165,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlCreateLabel("Optional Game Password:",270,202,155,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	$passinput = GUICtrlCreateInput(IniRead("KCHadv.ini",$profile,"Password","(default)"),435,202,125,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	$delaycombo1 = GuiCtrlCreateCombo("",270,225,85,420,$CBS_DROPDOWNLIST + $CBS_AUTOHSCROLL + $WS_VSCROLL + $WS_TABSTOP)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	local $read = iniread("KCHadv.ini",$profile,"DelayAction","0")
	if $read = 1 then
		GuiCtrlSetData(-1,"No Action|Delay|Stop","Delay")
	elseif $read = 2 then
		GuiCtrlSetData(-1,"No Action|Delay|Stop","Stop")
	Else
		GuiCtrlSetData(-1,"No Action|Delay|Stop","No Action")
	endif

	$delaylabel1 = GuiCtrlCreateLabel("After",360,227,30,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	$delayinput1 = GuictrlcreateInput(Iniread("KCHadv.ini",$profile,"VarTillDelay","0"),395,227,25,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	$delaycombo2 = GuiCtrlCreateCombo("",425,225,75,420,$CBS_DROPDOWNLIST + $CBS_AUTOHSCROLL + $WS_VSCROLL + $WS_TABSTOP)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	local $read = iniread("KCHadv.ini",$profile,"DelayTrigger","g")
	if $read == "m" then
		GuiCtrlSetData(-1,"Games|Minutes","Minutes")
	else
		GuiCtrlSetData(-1,"Games|Minutes","Games")
	endif
	$delaylabel2 = GuiCtrlCreateLabel("for",505,227,15,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	$delayinput2 = GuictrlcreateInput(Iniread("KCHadv.ini",$profile,"DelayTime","0"),525,227,25,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	$delaylabel3 = GuiCtrlCreateLabel("minutes",555,227,50,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	local $read = iniread("KCHadv.ini",$profile,"DelayAction","0")
	If $read == 1 then
		;All are enabled
	ElseIf $read == 2 then
		GuiCtrlSetState($delaylabel2, $GUI_DISABLE)
		GuiCtrlSetState($delaylabel3, $GUI_DISABLE)
		GuiCtrlSetState($delayinput2, $GUI_DISABLE)
	Else
		GuiCtrlSetState($delaycombo2, $GUI_DISABLE)
		GuiCtrlSetState($delaylabel1, $GUI_DISABLE)
		GuiCtrlSetState($delaylabel2, $GUI_DISABLE)
		GuiCtrlSetState($delaylabel3, $GUI_DISABLE)
		GuiCtrlSetState($delayinput1, $GUI_DISABLE)
		GuiCtrlSetState($delayinput2, $GUI_DISABLE)
	Endif
	GUICtrlCreateButton("Hold Current Game -->",430,290,135,40)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent( -1, "_starthold")
	GUICtrlCreateButton("Hunt with Selected Windows and Settings -->",330,340,235,40)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent( -1, "_starthunt")
	GUICtrlCreateButton("Select All",250,257,75,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent( -1, "_select1")
	GUICtrlCreateButton("Unselect All",250,297,75,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent( -1, "_unselect1")
	GUICtrlCreateButton("Close D2",350,257,75,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent( -1, "_close1")

	;;Tab 2 Controls
	$tab2 = GUICtrlCreateTabItem("Hunting Windows")
	$winlist2 = GUICtrlCreateListView("Window         |Status                    |Current Game   |Current IP       |Success Rate|Hunted Ip|Group",25,80,655,300,$LVS_SHOWSELALWAYS,BitOR($LVS_EX_GRIDLINES,$LVS_EX_CHECKBOXES))
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKBOTTOM + $GUI_DOCKLEFT + $GUI_DOCKRIGHT)
	GUICtrlCreateButton("Select All",25,40,70,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_select2")
	GUICtrlCreateButton("Unselect All",100,40,70,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_unselect2")
	GUICtrlCreateButton("Pause/Unpause",200,40,90,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_pauseadv")
	GUICtrlCreateButton("Change Ip",295,40,65,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_chgipadv")
	GUICtrlCreateButton("Change Delay",365,40,80,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_chgdelayadv")
	GUICtrlCreateButton("Join Game",450,40,70,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_joingameadv")
	GUICtrlCreateButton("Unload",565,40,50,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_close2")

	;;Tab 3 Controls
	$tab3 = GUICtrlCreateTabItem("Successful Windows")
	$winlist3 = GUICtrlCreateListView("Window         |Status                    |Current Game   |Current IP       |Success Rate|Hunted Ip|Group",25,80,655,300,$LVS_SHOWSELALWAYS,BitOR($LVS_EX_GRIDLINES,$LVS_EX_CHECKBOXES))
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKBOTTOM + $GUI_DOCKLEFT + $GUI_DOCKRIGHT)
	GUICtrlCreateButton("Select All",25,40,70,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_select3")
	GUICtrlCreateButton("Unselect All",100,40,70,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_unselect3")
	GUICtrlCreateButton("Leave Game",300,40,90,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_leavegame")
	GUICtrlCreateButton("Copy Game/Pass",395,40,100,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_copygame")
	GUICtrlCreateButton("Unload",565,40,50,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_close3")

	_liststartwindows()

	GUISetState(@SW_SHOW,$advGUI) ;Display GUI

	AdlibRegister("_getwinoutput",500)

	While 1
		if Not ($profile == GUICtrlRead($profilecombo)) Then
			_loadprofile()
			$profile = GUICtrlRead($profilecombo)
		EndIf
		Local $read = GUICtrlRead($delaycombo1)
		if $read == "No Action" Then
			If BitAND(GuiCtrlGetState($delayinput1), $GUI_ENABLE) Then
				GuiCtrlSetState($delaycombo2, $GUI_DISABLE)
				GuiCtrlSetState($delaylabel1, $GUI_DISABLE)
				GuiCtrlSetState($delaylabel2, $GUI_DISABLE)
				GuiCtrlSetState($delaylabel3, $GUI_DISABLE)
				GuiCtrlSetState($delayinput1, $GUI_DISABLE)
				GuiCtrlSetState($delayinput2, $GUI_DISABLE)
			EndIf
		ElseIf $read == "Stop" then
			If (BitAND(GuiCtrlGetState($delayinput1), $GUI_DISABLE) OR BitAND(GuiCtrlGetState($delayinput2), $GUI_ENABLE)) Then
				GuiCtrlSetState($delaycombo2, $GUI_ENABLE)
				GuiCtrlSetState($delaylabel1, $GUI_ENABLE)
				GuiCtrlSetState($delaylabel2, $GUI_DISABLE)
				GuiCtrlSetState($delaylabel3, $GUI_DISABLE)
				GuiCtrlSetState($delayinput1, $GUI_ENABLE)
				GuiCtrlSetState($delayinput2, $GUI_DISABLE)
			EndIf
		ElseIf $read == "Delay" Then
			If BitAND(GuiCtrlGetState($delayinput2), $GUI_DISABLE) Then
				GuiCtrlSetState($delaycombo2, $GUI_ENABLE)
				GuiCtrlSetState($delaylabel1, $GUI_ENABLE)
				GuiCtrlSetState($delaylabel2, $GUI_ENABLE)
				GuiCtrlSetState($delaylabel3, $GUI_ENABLE)
				GuiCtrlSetState($delayinput1, $GUI_ENABLE)
				GuiCtrlSetState($delayinput2, $GUI_ENABLE)
			EndIf
		Endif
		Sleep(500)
	WEnd
EndFunc

Func _close1()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 1 Then ;Check if in first tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 1 Then ;Check if in first tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				WinClose($windowtitlearray[$i][1])
				_wipeentry($windowtitlearray[$i][1])
				Sleep(50)
			EndIf
		EndIf
	Next
	_liststartwindows()
EndFunc

Func _close2()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				_exitclient($windowtitlearray[$i][2])
				_MoveListItem($windowtitlearray[$i][1],1)
			EndIf
		EndIf
	Next
	_liststartwindows()
EndFunc

Func _close3()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				_exitclient($windowtitlearray[$i][2])
				_MoveListItem($windowtitlearray[$i][1],1)
			EndIf
		EndIf
	Next
	_liststartwindows()
EndFunc

Func _select1()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 1 Then ;Check if in first tab
			GUICtrlSetState($windowtitlearray[$i][3],$GUI_CHECKED)
		EndIf
	Next
EndFunc

Func _unselect1()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 1 Then ;Check if in first tab
			GUICtrlSetState($windowtitlearray[$i][3],$GUI_UNCHECKED)
		EndIf
	Next
EndFunc

Func _select2()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			GUICtrlSetState($windowtitlearray[$i][3],$GUI_CHECKED)
		EndIf
	Next
EndFunc

Func _unselect2()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			GUICtrlSetState($windowtitlearray[$i][3],$GUI_UNCHECKED)
		EndIf
	Next
EndFunc

Func _select3()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			GUICtrlSetState($windowtitlearray[$i][3],$GUI_CHECKED)
		EndIf
	Next
EndFunc

Func _unselect3()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			GUICtrlSetState($windowtitlearray[$i][3],$GUI_UNCHECKED)
		EndIf
	Next
EndFunc

Func _pauseadv()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				_output($windowtitlearray[$i][2],"pause")
			EndIf
		EndIf
	Next
EndFunc

Func _chgipadv()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				Local $tempiplist = $windowtitlearray[$i][9]
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	Local $val = 1
	$IPList_old = $IPList
	While $val = 1
		$val = 0
		Do
			$InputIPList = InputBox($VersionInfo & ": IP List", "Please enter a list of IPs to search for, separated by commas. Only enter the last part of an IP address, not the entire IP address." & @CRLF & "Example: 66, 141" , $tempiplist , " M",Default,Default,Default,Default,30)

			If @error <> 0 Then
				$InputIPList = StringStripWS($IPList_old, 8)  ;; strip all spaces
				$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries

				ReDim $HuntedIPs [$SplitIPs[0]]
				$IPList = ""

				For $r = 1 To UBound($SplitIPs) - 1
					$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
					If $IPList = "" Then
						$IPList = $SplitIPs[$r]  ;; init to first split IP
					Else
						$IPList = $IPList & ", " & $SplitIPs[$r]
					EndIf

				Next
				Return
			EndIf

			$InputIPList = StringStripWS($InputIPList, 8)  ;; strip all spaces
			$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
		Until $SplitIPs[0] >= 1

		;; first element of array after Split is number of returned elements
		ReDim $HuntedIPs [$SplitIPs[0]]
		$IPList = ""

		For $r = 1 To UBound($SplitIPs) - 1
			if Not StringIsInt($SplitIPs[$r]) Then
				MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
				$val = 1
			EndIf
			$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
			If $IPList = "" Then
				$IPList = $SplitIPs[$r]  ;; init to first split IP
			Else
				$IPList = $IPList & ", " & $SplitIPs[$r]
			EndIf

		Next
	WEnd
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$windowtitlearray[$i][9] = $IPList
				_output($windowtitlearray[$i][2],"chgip:" & $windowtitlearray[$i][9])
			EndIf
		EndIf
	Next
EndFunc

Func _chgdelayadv()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	Local $value
	Do
        $value = InputBox($VersionInfo & ": Game duration", "Please enter how many seconds (at least 10) a game should last. Note: 180 seconds is generally a safe number to avoid getting IP banned after many tries.", "", " M",Default,Default,Default,Default,30)
		if @error = 1 Then
			Return
		EndIf
    Until (($value >= 10) AND (StringIsInt($value)))
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$windowtitlearray[$i][10] = $value
				_output($windowtitlearray[$i][2],"delay:" & $windowtitlearray[$i][10])
			EndIf
		EndIf
	Next
EndFunc

Func _joingameadv()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval == 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	Local $value
	Do
        $value = InputBox($VersionInfo & ": Join Manual Game", "Enter a Game//Password to have the bot hold", "", " M",Default,Default,Default,Default,30)
		if @error = 1 Then
			Return
		EndIf
    Until StringLen($value) >= 1
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				_output($windowtitlearray[$i][2],"join:" & $value)
				;ExitLoop ;;enable to allow multiple windows to join the same game for muling purposes
			EndIf
		EndIf
	Next
EndFunc

Func _leavegame()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				_output($windowtitlearray[$i][2],"leave")
			EndIf
		EndIf
	Next
EndFunc

Func _copygame()
	local $totalval = 0
	Local $clip = ""
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = $totalval + 1
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				if Not (($windowtitlearray[$i][6] == "") Or ($windowtitlearray[$i][6] == " ")) then
					if $totalval > 1 Then
						$clip = $clip & $windowtitlearray[$i][6] & @CRLF
					ElseIf $totalval = 1 Then
						$clip = $windowtitlearray[$i][6]
					EndIf
				EndIf
			EndIf
		EndIf
	Next
	if StringLen($clip) > 0 Then ClipPut($clip)
EndFunc

Func _loadprofile()
	Local $newprofile = GUICtrlRead($profilecombo)
	if IniRead("KCHadv.ini",$newprofile,"Difficulty","Hell") = "Normal" Then
		GUICtrlSetState($diffn,$GUI_CHECKED)
	Else
		GUICtrlSetState($diffh,$GUI_CHECKED)
	EndIf
	GUICtrlSetData($ipinput,IniRead("KCHadv.ini",$newprofile,"Hunted Ip","66, 141"))
	GUICtrlSetData($durationinput,IniRead("KCHadv.ini",$newprofile,"Duration",180))
	GUICtrlSetData($prefixinput,IniRead("KCHadv.ini",$newprofile,"Prefix","(random)"))
	GUICtrlSetData($passinput,IniRead("KCHadv.ini",$newprofile,"Password","(default)"))
	GUICtrlSetData($groupcombo,IniRead("KCHadv.ini",$newprofile,"Group","1"))
	if IniRead("KCHadv.ini",$newprofile,"Stop on Sale","1") == 1 Then
		GUICtrlSetState($salecheckbox,$GUI_CHECKED)
	Else
		GUICtrlSetState($salecheckbox,$GUI_UNCHECKED)
	EndIf
		if IniRead("KCHadv.ini",$newprofile,"GroupGameLimit","0") == 1 Then
		GUICtrlSetState($groupcheckbox,$GUI_CHECKED)
	Else
		GUICtrlSetState($groupcheckbox,$GUI_UNCHECKED)
	EndIf
	local $read = iniread("KCHadv.ini",$newprofile,"DelayAction","0")
	If $read == 1 then
		GuiCtrlSetData($delaycombo1,"Delay")
		GuiCtrlSetState($delaycombo2, $GUI_ENABLE)
		GuiCtrlSetState($delaylabel1, $GUI_ENABLE)
		GuiCtrlSetState($delaylabel2, $GUI_ENABLE)
		GuiCtrlSetState($delaylabel3, $GUI_ENABLE)
		GuiCtrlSetState($delayinput1, $GUI_ENABLE)
		GuiCtrlSetState($delayinput2, $GUI_ENABLE)
	ElseIf $read == 2 then
		GuiCtrlSetData($delaycombo1,"Stop")
		GuiCtrlSetState($delaycombo2, $GUI_ENABLE)
		GuiCtrlSetState($delaylabel1, $GUI_ENABLE)
		GuiCtrlSetState($delaylabel2, $GUI_DISABLE)
		GuiCtrlSetState($delaylabel3, $GUI_DISABLE)
		GuiCtrlSetState($delayinput1, $GUI_ENABLE)
		GuiCtrlSetState($delayinput2, $GUI_DISABLE)
	Else
		GuiCtrlSetData($delaycombo1,"No Action")
		GuiCtrlSetState($delaycombo2, $GUI_DISABLE)
		GuiCtrlSetState($delaylabel1, $GUI_DISABLE)
		GuiCtrlSetState($delaylabel2, $GUI_DISABLE)
		GuiCtrlSetState($delaylabel3, $GUI_DISABLE)
		GuiCtrlSetState($delayinput1, $GUI_DISABLE)
		GuiCtrlSetState($delayinput2, $GUI_DISABLE)
	Endif
	If iniread("KCHadv.ini",$newprofile,"DelayTrigger","g") == "g" Then
		GuiCtrlSetData($delaycombo2,"Games")
	ElseIf iniread("KCHadv.ini",$newprofile,"DelayTrigger","g")  == "m" Then
		GuiCtrlSetData($delaycombo2,"Minutes")
	endif
	GuiCtrlSetData($delayinput1,iniread("KCHadv.ini",$newprofile,"VarTillDelay","0"))
	GuiCtrlSetData($delayinput2,iniread("KCHadv.ini",$newprofile,"DelayTime","0"))
EndFunc

Func _starthunt()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 1 Then ;Check if in first tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	$checkval = _verifysettings()
	if $checkval = 0 Then
		IniWrite("KCHadv.ini",$profile,"Hunted IP",GUICtrlRead($ipinput))
		IniWrite("KCHadv.ini",$profile,"Duration",GUICtrlRead($durationinput))
		IniWrite("KCHadv.ini",$profile,"Prefix",GUICtrlRead($prefixinput))
		IniWrite("KCHadv.ini",$profile,"Password",GUICtrlRead($passinput))
		if GUICtrlRead($diffh) = $GUI_CHECKED Then
			IniWrite("KCHadv.ini",$profile,"Difficulty","Hell")
		Elseif GUICtrlRead($diffn) = $GUI_CHECKED Then
			IniWrite("KCHadv.ini",$profile,"Difficulty","Normal")
		EndIf
		if GUICtrlRead($salecheckbox) = $GUI_CHECKED Then
			IniWrite("KCHadv.ini",$profile,"Stop on Sale","1")
		Else
			IniWrite("KCHadv.ini",$profile,"Stop on Sale","0")
		EndIf
		if GUICtrlRead($groupcheckbox) = $GUI_CHECKED Then
			IniWrite("KCHadv.ini",$profile,"GroupGameLimit","1")
		Else
			IniWrite("KCHadv.ini",$profile,"GroupGameLimit","0")
		EndIf
		IniWrite("KCHadv.ini",$profile,"Group",GUICtrlRead($groupcombo))
		local $read = GuiCtrlRead($delaycombo1)
		if $read == "Delay" then
			iniwrite("KCHadv.ini",$profile,"DelayAction","1")
		elseif $read == "Stop" Then
			iniwrite("KCHadv.ini",$profile,"DelayAction","2")
		else
			iniwrite("KCHadv.ini",$profile,"DelayAction","0")
		endif
		local $read = GuiCtrlRead($delaycombo2)
		if $read == "Games" then
			iniwrite("KCHadv.ini",$profile,"DelayTrigger","g")
		else
			iniwrite("KCHadv.ini",$profile,"DelayAction","m")
		endif
		iniwrite("KCHadv.ini",$profile,"VarTillDelay",GuiCtrlRead($delayinput1))
		iniwrite("KCHadv.ini",$profile,"DelayTime",GuiCtrlRead($delayinput2))
		Local $startnum1 = 0
		Local $startnum2 = 0
		;; Loop through first to get the total number of windows to launch
		for $i = 1 to (UBound($windowtitlearray) -1)
			if Not ($windowtitlearray[$i][0] == "") Then ;Make sure window exists
				if $windowtitlearray[$i][4] == 1 Then ;Check if in first tab
					if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
						if Not (GUICtrlRead($prefixinput) == "(random)") Then
							for $j = 1 to (UBound($windowtitlearray) -1)
								if $windowtitlearray[$j][11] == GUICtrlRead($prefixinput) Then
									ContinueLoop ;go to next loop
								EndIf
							Next
						EndIf
						$startnum1 = $startnum1 + 1
					EndIf
				EndIf
			EndIf
		Next

		for $i = 1 to (UBound($windowtitlearray) -1)
			if Not ($windowtitlearray[$i][0] == "") Then ;Make sure window exists
				if $windowtitlearray[$i][4] == 1 Then ;Check if in first tab
					if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
						if Not (GUICtrlRead($prefixinput) == "(random)") Then
							Local $tempprefix = GUICtrlRead($prefixinput)
							for $j = 1 to (UBound($windowtitlearray) -1)
								if $windowtitlearray[$j][11] == $tempprefix Then
									$tempprefix = _gameprefixfix($tempprefix, 1)
									if Not @error Then
										$windowtitlearray[$i][11] = $tempprefix
										ExitLoop
									Else
										MsgBox(0,$VersionInfo, "Error: Game Prefix must be unique!")
										ContinueLoop 2 ;go to next loop
									EndIf
								ElseIf $j = (UBound($windowtitlearray) -1) Then
									$windowtitlearray[$i][11] = $tempprefix
								EndIf
							Next
						Else
							$windowtitlearray[$i][11] = Chr(96 + Random(1, 26, 1)) & Random(100, 999, 1) & "-"
						EndIf
						$windowtitlearray[$i][9] = GUICtrlRead($ipinput)
						$windowtitlearray[$i][10] = GUICtrlRead($durationinput)
						$windowtitlearray[$i][12] = GUICtrlRead($passinput)
						if GUICtrlRead($diffh) = $GUI_CHECKED Then
							$windowtitlearray[$i][13] = "h"
						Elseif GUICtrlRead($diffn) = $GUI_CHECKED Then
							$windowtitlearray[$i][13] = "n"
						EndIf
						Local $classname = _WinAPI_GetClassName($windowtitlearray[$i][1])
						if StringRegExp($classname,'\ASandbox:([A-Za-z0-9]+):Diablo II\Z',0) Then ;;check if it is inside a sandbox so we can launch KCHClient properly
							$windowtitlearray[$i][14] = StringTrimRight(StringTrimLeft($classname,8),10)
						EndIf
						$windowtitlearray[$i][15] = GUICtrlRead($groupcombo)
						if GUICtrlRead($salecheckbox) == $GUI_CHECKED Then
							$windowtitlearray[$i][16] = 1
						Else
							$windowtitlearray[$i][16] = 0
						EndIf
						If GUICtrlRead($groupcheckbox) == $GUI_CHECKED Then
							$windowtitlearray[$i][20] = 1
						Else
							$windowtitlearray[$i][20] = 0
						EndIf
						local $read = GuiCtrlRead($delaycombo1)
						if $read == "Delay" then
							$windowtitlearray[$i][19] = GuiCtrlRead($delayinput2)
							if GuiCtrlRead($delaycombo2) == "Games" Then
								$windowtitlearray[$i][17] = GuiCtrlRead($delayinput1)
								$windowtitlearray[$i][18] = 0
							else ;"Minutes"
								$windowtitlearray[$i][17] = 0
								$windowtitlearray[$i][18] = GuiCtrlRead($delayinput1)
							endif
						elseif $read == "Stop" Then
							$windowtitlearray[$i][19] = -1
							if GuiCtrlRead($delaycombo2) == "Games" Then
								$windowtitlearray[$i][17] = GuiCtrlRead($delayinput1)
								$windowtitlearray[$i][18] = 0
							else ;"Minutes"
								$windowtitlearray[$i][17] = 0
								$windowtitlearray[$i][18] = GuiCtrlRead($delayinput1)
							endif
						else ;"No Action"
							$windowtitlearray[$i][17] = 0
							$windowtitlearray[$i][18] = 0
							$windowtitlearray[$i][19] = 0
						endif
						AdlibRegister("_getwinoutput",3000) ;slow down scan so we can launch lots of windows without hanging
						_launchclient($windowtitlearray[$i][1],$startnum2*$windowtitlearray[$i][10]/$startnum1)
						AdlibRegister("_getwinoutput",500) ;return scan to full speed
						if Not ($windowtitlearray[$i][2] == -1) Then _MoveListItem($windowtitlearray[$i][1], 2) ;;check if launched correctly
						$startnum2 = $startnum2 + 1
					EndIf
				EndIf
			EndIf
		Next

	ElseIf $checkval = 2 Then
		GUICtrlSetState($ipinput,$GUI_FOCUS)
	ElseIf $checkval = 3 Then
		GUICtrlSetState($durationinput,$GUI_FOCUS)
	ElseIf $checkval = 4 Then
		GUICtrlSetState($prefixinput,$GUI_FOCUS)
	ElseIf $checkval = 5 Then
		GUICtrlSetState($passinput,$GUI_FOCUS)
	ElseIf $checkval = 6 Then
		GUICtrlSetState($delayinput1,$GUI_FOCUS)
	ElseIf $checkval = 7 Then
		GUICtrlSetState($delayinput2,$GUI_FOCUS)
	EndIf
EndFunc

Func _starthold()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 1 Then ;Check if in first tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	Local $curval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if Not ($windowtitlearray[$i][0] == "") Then ;Make sure window exists
			if $windowtitlearray[$i][4] == 1 Then ;Check if in first tab
				if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
					Local $classname = _WinAPI_GetClassName($windowtitlearray[$i][1])
					if StringRegExp($classname,'\ASandbox:([A-Za-z0-9]+):Diablo II\Z',0) Then ;;check if it is inside a sandbox so we can launch KCHClient properly
						$windowtitlearray[$i][14] = StringTrimRight(StringTrimLeft($classname,8),10)
					EndIf
					AdlibRegister("_getwinoutput",3000) ;slow down scan so we can launch lots of windows without hanging
					_launchholdclient($windowtitlearray[$i][1],$curval)
					AdlibRegister("_getwinoutput",500) ;return scan to full speed
					$curval = $curval +2 ;add 2 second delay for every additional window
					if Not ($windowtitlearray[$i][2] == -1) Then _MoveListItem($windowtitlearray[$i][1], 2) ;;check if launched correctly
				EndIf
			EndIf
		EndIf
	Next
EndFunc

Func _gameprefixfix($rec, $num) ;;Recursive function to modify dupicate game prefixes
	Local $val1
	if $num >= 100 Then ;make sure we dont go over 99 recursive calls
		SetError(1)
		Return
	EndIf
	Local $fixprefix = $rec & $num & "-"
	for $val1 = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$val1][11] == $fixprefix Then
			Local $return = _gameprefixfix($rec, $num + 1) ;call recurive function
			if Not @error Then
				Return $return
			Else
				SetError(1)
				Return
			EndIf
		EndIf
	Next
	Return $fixprefix ;return if untaken
EndFunc

Func _verifysettings()
	$InputIPList = StringStripWS(GUICtrlRead($ipinput), 8)  ;; strip all spaces
	$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
	if Not ($SplitIPs[0] >= 1) Then
		MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
		Return 2
	EndIf
	if Not (GUICtrlRead($durationinput) >= 10 And StringIsInt(GUICtrlRead($durationinput))) Then
		MsgBox(48,$VersionInfo,"Game Duration must be an integer and greater than 10 seconds!")
		Return 3
	EndIf

	if GUICtrlRead($prefixinput) = "" Or StringLen(GUICtrlRead($prefixinput)) > 10 Then
		MsgBox(48,$VersionInfo,"Game Prefix must exist and cannot exceed 10 characters!")
		Return 4
	EndIf

	Local $val = GUICtrlRead($prefixinput)
	if Not ($val == "(random)") Then
		for $i=1 to StringLen($val)
			Local $val2 = StringMid($val,$i,1)
			if Not (StringIsAlNum($val2) or ($val2 == "-") or ($val2 == "_") or ($val2 == "'") or (($val2 == " ") And ($i > 1))) Then
				MsgBox(48,$VersionInfo,"Game Prefix cannot contain those invalid characters")
				Return 4
			EndIf
		Next
	EndIf

	if StringLen(GUICtrlRead($passinput)) > 10 Then
		MsgBox(48,$VersionInfo,"Game Password cannot exceed 10 characters!")
		Return 5
	EndIf

	Local $val = GUICtrlRead($passinput)
	if Not ($val == "(default)") Then
		for $i=1 to StringLen($val)
			Local $val2 = StringMid($val,$i,1)
			if Not (StringIsAlNum($val2) or ($val2 == "-") or ($val2 == "_") or ($val2 == "'") or (($val2 == " ") And ($i > 1))) Then
				MsgBox(48,$VersionInfo,"Game Password cannot contain those invalid characters")
				Return 5
			EndIf
		Next
	EndIf
	If BitAND(GuiCtrlGetState($delayinput1), $GUI_ENABLE) Then
		local $read = GuiCtrlRead($delayinput1)

		If StringIsInt($read) then
			If Not ($read >= 1) then
				MsgBox(48,$VersionInfo,"Enter value as a positive integer")
				return 6
			endif
		Else
			MsgBox(48,$VersionInfo,"Enter value as a positive integer")
			return 6
		endif
	EndIf
	If BitAND(GuiCtrlGetState($delayinput2), $GUI_ENABLE) Then
		local $read = GuiCtrlRead($delayinput2)
		If StringIsInt($read) then
			If Not ($read >= 1) then
				MsgBox(48,$VersionInfo,"Enter time as a positive integer")
				return 7
			endif
		Else
			MsgBox(48,$VersionInfo,"Enter time as a positive integer")
			return 7
		endif
	EndIf
	;; first element of array after Split is number of returned elements
    ReDim $HuntedIPs [$SplitIPs[0]]
    $IPList = ""
	For $r = 1 To UBound($SplitIPs) - 1
		if Not StringIsInt($SplitIPs[$r]) Then
			MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
			Return 2
		ElseIf StringLen($SplitIPs[$r]) > 3 Then
			MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
			Return 2
		ElseIf StringLen($SplitIPs[$r]) < 2 Then
			MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
			Return 2
		EndIf
    Next
	Return 0
EndFunc

Func _exitadv()
	_exitall()
	Exit
EndFunc

Func _opencounts()
	ShellExecute("counts.url")
EndFunc

Func _openlog()
	ShellExecute("KCHlog.txt")
EndFunc

Func _openreadme()
	ShellExecute("readme.txt")
EndFunc

Func _MoveListItem($handle, $tabnum)
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][1] = $handle Then
			if Not ($tabnum == $windowtitlearray[$i][4]) Then ;;Make sure we dont try to move it to the same tab
				if $tabnum = 1 Then
					$windowtitlearray[$i][2] = -1
					GUICtrlDelete($windowtitlearray[$i][3]) ;;Delete GUI Control
					$windowtitlearray[$i][3] = GUICtrlCreateListViewItem($windowtitlearray[$i][0] & "|" & $windowtitlearray[$i][1], $winlist1) ;;Create GUI Control in Tab1
					$windowtitlearray[$i][4] = 1
					$windowtitlearray[$i][5] = ""
					$windowtitlearray[$i][6] = ""
					$windowtitlearray[$i][7] = ""
					$windowtitlearray[$i][8] = ""
					$windowtitlearray[$i][9] = ""
					$windowtitlearray[$i][10] = ""
					$windowtitlearray[$i][11] = ""
					$windowtitlearray[$i][12] = ""
					$windowtitlearray[$i][13] = ""
					$windowtitlearray[$i][14] = ""
					$windowtitlearray[$i][15] = ""
					$windowtitlearray[$i][16] = ""
					$windowtitlearray[$i][17] = ""
					$windowtitlearray[$i][18] = ""
					$windowtitlearray[$i][19] = ""
					$windowtitlearray[$i][20] = ""
				ElseIf $tabnum = 2 Then
					GUICtrlDelete($windowtitlearray[$i][3]) ;;Delete GUI Control
					$windowtitlearray[$i][3] = GUICtrlCreateListViewItem($windowtitlearray[$i][0] & "|" & $windowtitlearray[$i][5] & "|" & $windowtitlearray[$i][6] & "|" & $windowtitlearray[$i][7] & "|" & $windowtitlearray[$i][8] & "|" & $windowtitlearray[$i][9] & "|" & $windowtitlearray[$i][15], $winlist2) ;;Create GUI Control in Tab2
					$windowtitlearray[$i][4] = 2
				ElseIf $tabnum = 3 Then
					GUICtrlDelete($windowtitlearray[$i][3]) ;;Delete GUI Control
					$windowtitlearray[$i][3] = GUICtrlCreateListViewItem($windowtitlearray[$i][0] & "|" & $windowtitlearray[$i][5] & "|" & $windowtitlearray[$i][6] & "|" & $windowtitlearray[$i][7] & "|" & $windowtitlearray[$i][8] & "|" & $windowtitlearray[$i][9] & "|" & $windowtitlearray[$i][15], $winlist3) ;;Create GUI Control in Tab3
					$windowtitlearray[$i][4] = 3
				EndIf
			EndIf
			ExitLoop
		EndIf
	Next
	_liststartwindows()
EndFunc

Func _liststartwindows()
	AutoItSetOption("WinTitleMatchMode", 4)  ;; classname
	$winarray1 = WinList("classname=Diablo II")
	$winarray2 = WinList("[REGEXPCLASS:\ASandbox:([A-Za-z0-9]+):Diablo II\Z]") ;scan for sandboxie D2 windows
	AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match

	;detect if our sandboxie folder settings are correct
	if $winarray2[0][0] > 0 Then
		if not FileExists(IniRead("KCHadv.ini","Reserved","Sandboxie","C:\Program Files\Sandboxie\") & "Start.exe") Then
			MsgBox(48,$VersionInfo,"KCH has detected sandboxie windows, but has failed to detect your sandboxie install folder." & @CRLF & "Please set the correct folder under Sandboxie in KCHadv.ini")
			ShellExecute("KCHadv.ini")
			_exitadv()
		EndIf
	EndIf

	$windowtitlearray[0][0] = $winarray1[0][0] + $winarray2[0][0] ;;total number of windows

	for $i = 1 to (UBound($windowtitlearray) -1) ;Make sure all windows still exist
		if Not ($windowtitlearray[$i][0] == "") Then ;Make sure data entry exists
			Local $winval = 0
			;loop through regular windows
			for $j = 1 to $winarray1[0][0]
				if $windowtitlearray[$i][1] == $winarray1[$j][1] Then ;;matching winhandles
					ExitLoop
				ElseIf $j >= $winarray1[0][0] Then ;reached end of winlist and not present
					$winval = 1
				EndIf
			Next
			;loop through sandboxed windows
			for $j = 1 to $winarray2[0][0]
				if $windowtitlearray[$i][1] == $winarray2[$j][1] Then ;;matching winhandles
					ExitLoop
				ElseIf $j >= $winarray2[0][0] Then ;reached end of winlist and not present
					If $winval = 1 Then
						if Not ($windowtitlearray[$i][2] == -1) Then ;client exists
							_exitclient($windowtitlearray[$i][2])
							MsgBox(0,$VersionInfo,"Window: " & $windowtitlearray[$i][0] & " does not exist anymore. Stopping that instance")
						EndIf
						_wipeentry($windowtitlearray[$i][1]) ;clear data entry and remove from GUI
					EndIf
				EndIf
			Next
			if Not WinExists($windowtitlearray[$i][1]) Then _wipeentry($windowtitlearray[$i][1]) ;clear data entry and remove from GUI
		EndIf
	Next

	;loop through regular windows
	for $i = 1 to $winarray1[0][0]
		Local $exists = 0
		for $k = 1 to (UBound($windowtitlearray) -1) ;Make sure window entry doesn't already exist
			if $winarray1[$i][1] = $windowtitlearray[$k][1] Then
				$exists = 1
				ExitLoop
			EndIf
		Next
		if $exists = 0 Then
			for $j = 1 to (UBound($windowtitlearray) -1) ;Add new windows if not entered yet
				if $windowtitlearray[$j][0] = "" Then ;Make sure entry is blank
					$windowtitlearray[$j][0] = $winarray1[$i][0] ;;window title
					$windowtitlearray[$j][1] = $winarray1[$i][1] ;;window handle
					$windowtitlearray[$j][2] = -1 ;;null client pid
					$windowtitlearray[$j][3] = GUICtrlCreateListViewItem($windowtitlearray[$j][0] & "|" & $windowtitlearray[$j][1] ,$winlist1)
					$windowtitlearray[$j][4] = 1
					GUICtrlSetState($windowtitlearray[$j][3],$GUI_CHECKED)
					ExitLoop ;;added, onto next entry
				ElseIf $j >= 99 Then
					MsgBox(0,$VersionInfo,"Error, too many windows. Max of 99 reached. Please edit the code manually to allow more")
					ExitLoop 2 ;;Stop looping, error
				EndIf
			Next
		EndIf
	Next
	;loop through sandboxed windows
	for $i = 1 to $winarray2[0][0]
		Local $exists = 0
		for $k = 1 to (UBound($windowtitlearray) -1) ;Make sure window entry doesn't already exist
			if $winarray2[$i][1] = $windowtitlearray[$k][1] Then
				$exists = 1
				ExitLoop
			EndIf
		Next
		if $exists = 0 Then
			for $j = 1 to (UBound($windowtitlearray) -1) ;Add new windows if not entered yet
				if $windowtitlearray[$j][0] = "" Then ;Make sure entry is blank
					$windowtitlearray[$j][0] = $winarray2[$i][0] ;;window title
					$windowtitlearray[$j][1] = $winarray2[$i][1] ;;window handle
					$windowtitlearray[$j][2] = -1 ;;null client pid
					$windowtitlearray[$j][3] = GUICtrlCreateListViewItem($windowtitlearray[$j][0] & "|" & $windowtitlearray[$j][1] ,$winlist1)
					$windowtitlearray[$j][4] = 1
					GUICtrlSetState($windowtitlearray[$j][3],$GUI_CHECKED)
					ExitLoop ;;added, onto next entry
				ElseIf $j >= 99 Then
					MsgBox(0,$VersionInfo,"Error, too many windows. Max of 99 reached. Please edit the code manually to allow more")
					ExitLoop 2 ;;Stop looping, error
				EndIf
			Next
		EndIf
	Next

	Local $total = 0 ;total number of non-hunting windows
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 1 Then $total = $total + 1
	Next

	GUICtrlSetData($totallabel, "Detected Windows: " & $windowtitlearray[0][0] & @crlf & "Not Hunting: " & $total)
EndFunc

Func _wipeentry($handle)
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][1] = $handle Then
			if Not ($windowtitlearray[$i][3] == "") Then GUICtrlDelete($windowtitlearray[$i][3]) ;;Delete GUI entry if it exists
			;;Remove all data on entry
			$windowtitlearray[$i][0] = ""
			$windowtitlearray[$i][1] = ""
			$windowtitlearray[$i][2] = ""
			$windowtitlearray[$i][3] = ""
			$windowtitlearray[$i][4] = ""
			$windowtitlearray[$i][5] = ""
			$windowtitlearray[$i][6] = ""
			$windowtitlearray[$i][7] = ""
			$windowtitlearray[$i][8] = ""
			$windowtitlearray[$i][9] = ""
			$windowtitlearray[$i][10] = ""
			$windowtitlearray[$i][11] = ""
			$windowtitlearray[$i][12] = ""
			$windowtitlearray[$i][13] = ""
			$windowtitlearray[$i][14] = ""
			$windowtitlearray[$i][15] = ""
			$windowtitlearray[$i][16] = ""
			$windowtitlearray[$i][17] = ""
			$windowtitlearray[$i][18] = ""
			$windowtitlearray[$i][19] = ""
			$windowtitlearray[$i][20] = ""
			ExitLoop
		EndIf
	Next
EndFunc

Func _launchclient($handle, $startdelay = 0)
	for $i = 1 to (UBound($windowtitlearray) -1)
		if Not ($windowtitlearray[$i][0] == "") Then ;;has a valid window
			if $windowtitlearray[$i][1] == $handle Then
				$pidreturn = _RunClient($windowtitlearray[$i][1],$windowtitlearray[$i][13],$windowtitlearray[$i][9],$windowtitlearray[$i][10],$windowtitlearray[$i][11],$windowtitlearray[$i][12],$windowtitlearray[$i][14],$startdelay,$windowtitlearray[$i][16],$windowtitlearray[$i][17],$windowtitlearray[$i][18],$windowtitlearray[$i][19])
				if Not ($pidreturn == -1) Then $windowtitlearray[$i][2] = $pidreturn
			EndIf
		EndIf
	Next
EndFunc

Func _launchholdclient($handle, $startdelay = 0)
	for $i = 1 to (UBound($windowtitlearray) -1)
		if Not ($windowtitlearray[$i][0] == "") Then ;;has a valid window
			if $windowtitlearray[$i][1] == $handle Then
				$pidreturn = _RunHoldClient($windowtitlearray[$i][1],$windowtitlearray[$i][14],$startdelay)
				if Not ($pidreturn == -1) Then $windowtitlearray[$i][2] = $pidreturn
			EndIf
		EndIf
	Next
EndFunc

Func _exitclient($pid)
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][2] = $pid Then
			_output($windowtitlearray[$i][2], "exit")
			ExitLoop
		EndIf
	Next
EndFunc

Func _exitall()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if Not ($windowtitlearray[$i][2] == "") Then
			_output($windowtitlearray[$i][2], "exit")
			_wipeentry($windowtitlearray[$i][1])
		EndIf
	Next
EndFunc

Func _RunClient($handle, $difficulty, $ips, $delay, $prefix, $pass, $sandbox, $startdelay, $saleopt, $delayasgames, $delayastime, $delaypause)
	if Not FileExists($AdvClientFile) Then
		MsgBox(0,$VersionInfo,"Error, " & $AdvClientFile & " is not detected. Exiting")
		_exitadv()
	EndIf
	Local $pid
	if $sandbox == "" Then ;;regular d2 window
		$pid = Run($AdvClientFile & " launch")
		if @error Then Return -1
		Local $i = 1
		while $i < 20 ;;Give the program time to load
			if WinExists("KCHClient-" & $pid) then ExitLoop
			$i = $i + 1
			Sleep(250)
		WEnd
		if $i >= 20 Then
			MsgBox(0,$VersionInfo,"Failed to launch KCH's client process correctly",3)
			Return -1
		EndIf
	Else ;;sandboxed d2 window
		if not FileExists(IniRead("KCHadv.ini","Reserved","Sandboxie","C:\Program Files\Sandboxie\") & "Start.exe") Then
			MsgBox(48,$VersionInfo,"Failed to launch KCH's client process in the sandbox: " & $sandbox & " correctly." & @CRLF & "Please make sure you have the sandbox ini setting set to the correct folder")
			Return -1
		EndIf
		Run(IniRead("KCHadv.ini","Reserved","Sandboxie","C:\Program Files\Sandboxie\") & "Start.exe /silent /box:" & $sandbox & " " & @ScriptDir & "\" & $AdvClientFile & " launch")
		if @error Then Return -1
		Local $i = 1
		while $i < 30 ;;Give the program time to load
			AutoItSetOption("WinTitleMatchMode", 4)  ;; classname
			$sandarray = WinList("classname=Sandbox:" & $sandbox & ":AutoIt v3 GUI")
			AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match
			for $i = 1 to $sandarray[0][0]
				Local $regexp = StringRegExp($sandarray[$i][0], "KCHClient-[\d]*", 1)
				for $j = 0 to UBound($regexp) - 1
					$pid = StringTrimLeft($regexp[$j],10)
					ExitLoop 3
				Next
			Next
			Sleep(250)
		WEnd
		if $i >= 30 Then
			MsgBox(0,$VersionInfo,"Failed to launch KCH's client process in the sandbox: " & $sandbox & " correctly",3)
			Return -1
		EndIf

	EndIf
	Local $read = IniRead("KCHadv.ini","Reserved","Advanced HeavyLogging",0)
	if $read == 1 Then
		$heavylog = 1
	Else
		$heavylog = 0
	EndIf
	_output($pid, "start|" & $handle &"|"& $difficulty & "|" & $ips &"|"& Int($delay) &"|"& $prefix &"|"& $pass & "|" & WinGetProcess($handle) & "|" & Int($startdelay) & "|" & $DelayBeforeNewGameSeconds & "|" & $saleopt & "|" & $delayasgames & "|" & $delayastime & "|" & $delaypause & "|" & $heavylog)
	Return $pid
EndFunc

Func _RunHoldClient($handle, $sandbox, $startdelay)
	if Not FileExists($AdvClientFile) Then
		MsgBox(0,$VersionInfo,"Error, " & $AdvClientFile & " is not detected. Exiting")
		_exitadv()
	EndIf
	Local $pid
	if $sandbox == "" Then ;;regular d2 window
		$pid = Run($AdvClientFile & " launch")
		if @error Then Return -1
		Local $i = 1
		while $i < 20 ;;Give the program time to load
			if WinExists("KCHClient-" & $pid) then ExitLoop
			$i = $i + 1
			Sleep(250)
		WEnd
		if $i >= 20 Then
			MsgBox(0,$VersionInfo,"Failed to launch KCH's client process correctly",3)
			Return -1
		EndIf
	Else ;;sandboxed d2 window
		if not FileExists(IniRead("KCHadv.ini","Reserved","Sandboxie","C:\Program Files\Sandboxie\") & "Start.exe") Then
			MsgBox(48,$VersionInfo,"Failed to launch KCH's client process in the sandbox: " & $sandbox & " correctly." & @CRLF & "Please make sure you have the sandbox ini setting set to the correct folder")
			Return -1
		EndIf
		Run(IniRead("KCHadv.ini","Reserved","Sandboxie","C:\Program Files\Sandboxie\") & "Start.exe /silent /box:" & $sandbox & " " & @ScriptDir & "\" & $AdvClientFile & " launch")
		if @error Then Return -1
		Local $i = 1
		while $i < 30 ;;Give the program time to load
			AutoItSetOption("WinTitleMatchMode", 4)  ;; classname
			$sandarray = WinList("classname=Sandbox:" & $sandbox & ":AutoIt v3 GUI")
			AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match
			for $i = 1 to $sandarray[0][0]
				Local $regexp = StringRegExp($sandarray[$i][0], "KCHClient-[\d]*", 1)
				for $j = 0 to UBound($regexp) - 1
					$pid = StringTrimLeft($regexp[$j],10)
					ExitLoop 3
				Next
			Next
			Sleep(250)
		WEnd
		if $i >= 30 Then
			MsgBox(0,$VersionInfo,"Failed to launch KCH's client process in the sandbox: " & $sandbox & " correctly",3)
			Return -1
		EndIf

	EndIf
	Local $read = IniRead("KCHadv.ini","Reserved","Advanced HeavyLogging",0)
	if $read == 1 Then
		$heavylog = 1
	Else
		$heavylog = 0
	EndIf
	_output($pid, "starthold|" & $handle & "|" & WinGetProcess($handle) & "|" & $heavylog & "|" & Int($startdelay))
	Return $pid
EndFunc

Func _output($pid, $message)
	AutoItSetOption("WinTitleMatchMode", 2)  ;; any
	Local $list = WinList("KCHClient-" & $pid)
	AutoItSetOption("WinTitleMatchMode", 3)  ;; exact
	for $i = 1 to $list[0][0]
		if StringRegExp($list[$i][0],"KCHClient-" & $pid & "[\D]?") Then ;;make sure the string ends where specified
			ControlSetText($list[$i][1],"",3,$message) ;;output
			ExitLoop
		EndIf
	Next
EndFunc

Func _getwinoutput()
;~ ControlGetText("KCHClient-" & $pid,"",4) ;;input
;~ ControlSetText("KCHClient-" & $pid,"",3,"exit") ;;output
;~ ControlGetText("KCHClient-" & $pid,"",5) ;;log
	for $i = 1 to (UBound($windowtitlearray) -1)
		if Not ($windowtitlearray[$i][0] == "") Then ;Make sure data entry exists
			if Not ($windowtitlearray[$i][2] == -1) Then ;Make sure client pid exists
				AutoItSetOption("WinTitleMatchMode", 2)  ;; any
				Local $list = WinList("KCHClient-" & $windowtitlearray[$i][2])
				AutoItSetOption("WinTitleMatchMode", 3)  ;; exact
				for $j = 1 to $list[0][0]
					if StringRegExp($list[$j][0],"KCHClient-" & $windowtitlearray[$i][2] & "[\D]?") Then ;;make sure the string ends where specified
						Local $logline1 = ControlGetText($list[$j][1],"",5)
						if $logline1 <> "" Then
							ControlSetText($list[$j][1],"",5,"")
							;;;;;;;;REPORTER;;;;;
							if $reporter Then
								if StringInStr($logline1,"@") Then
									if FileExists($ReporterFile) Then
										if $windowtitlearray[$i][14] == "" Then ;not a sandboxed window
											Run($ReporterFile & " " & WinGetProcess($windowtitlearray[$i][1]))
										Else ;this is a sandboxed window
											Run(IniRead("KCHadv.ini","Reserved","Sandboxie","C:\Program Files\Sandboxie\") & "Start.exe /silent /box:" & $windowtitlearray[$i][14] & " " & @ScriptDir & "\" & $ReporterFile & " " & WinGetProcess($windowtitlearray[$i][1]))
										EndIf
									EndIf
								EndIf
							EndIf
							;;;;;;;;REPORTER;;;;;
							Local $loglineA = StringSplit($logline1,@CRLF,1)
							for $k = 1 to $loglineA[0]
								Local $logline2 = StringSplit($loglineA[$k]," ")
								Local $logwrite = $logline2[1] & " " & $logline2[2] & " " & $logline2[3] & " " & $windowtitlearray[$i][0] & " " & $logline2[4] & ": "
								for $z = 5 to (UBound($logline2) - 1)
									$logwrite = $logwrite & $logline2[$z] & " "
								Next
								$logwrite = StringTrimRight($logwrite,1)

								;play sound on sale/walk
								if StringInStr($logwrite,"@") Then
									if StringInStr($logwrite,"@WALK") Then
										if TimerDiff($WalkSoundTimer) > 3000 Then
											$WalkSoundTimer = TimerInit()
											Local $sound = _SoundOpen($WalkSoundFile)
											_SoundPlay($sound)
										EndIf
									Else
										if TimerDiff($SaleSoundTimer) > 3000 Then
											$SaleSoundTimer = TimerInit()
											Local $sound = _SoundOpen($SaleSoundFile)
											_SoundPlay($sound)
										EndIf
									EndIf
								EndIf

								FileWriteLine("KCHLog.txt",$logwrite)
							Next
						EndIf
						Local $winoutput = ControlGetText($list[$j][1],"",4)
						if @error Then
							;GUICtrlSetData($windowtitlearray[$i][3],$windowtitlearray[$i][0] & "|ERROR|ERROR|ERROR|ERROR|ERROR")
							;_wipeentry($windowtitlearray[$i][1])
						Else
							if StringLen($winoutput) >= 3 Then ;Make sure string is really there
								Local $winoutput2 = StringSplit($winoutput,'|')
								if $winoutput2[0] == 4 Then ;;make sure we don't get an autoit error
									$windowtitlearray[$i][5] = $winoutput2[1]
									$windowtitlearray[$i][6] = $winoutput2[2]
									$windowtitlearray[$i][7] = $winoutput2[3]
									$windowtitlearray[$i][8] = $winoutput2[4]
									if $windowtitlearray[$i][5] == "Exiting" Then _wipeentry($windowtitlearray[$i][1])
									if $windowtitlearray[$i][4] = 2 Then
										GUICtrlSetData($windowtitlearray[$i][3],$windowtitlearray[$i][0] & "|" & $windowtitlearray[$i][5] & "|" & $windowtitlearray[$i][6] & "|" & $windowtitlearray[$i][7] & "|" & $windowtitlearray[$i][8] & "|" & $windowtitlearray[$i][9] & "|" & $windowtitlearray[$i][15])
										if StringLeft($winoutput,5) == "Found" Then
											_MoveListItem($windowtitlearray[$i][1],3)
											WinFlash($advGUI)
										EndIf
										if StringRight($windowtitlearray[$i][5],5) == "@WALK" Then
											WinFlash($advGUI)
										EndIf
										if StringLeft($winoutput,8) == "Detected" Then
											_MoveListItem($windowtitlearray[$i][1],3)
											WinFlash($advGUI)
										EndIf
										if StringLeft($winoutput,4) == "Held" Then _MoveListItem($windowtitlearray[$i][1],3)
										if StringLeft($winoutput,9) == "Rejoining" Then _MoveListItem($windowtitlearray[$i][1],3)
										if StringRight($winoutput2[1],1) == " " Then _MoveListItem($windowtitlearray[$i][1],3) ;;Space at the end of 'Status' means this is a sale on a held game
									elseif $windowtitlearray[$i][4] = 3 Then
										GUICtrlSetData($windowtitlearray[$i][3],$windowtitlearray[$i][0] & "|" & $windowtitlearray[$i][5] & "|" & $windowtitlearray[$i][6] & "|" & $windowtitlearray[$i][7] & "|" & $windowtitlearray[$i][8] & "|" & $windowtitlearray[$i][9] & "|" & $windowtitlearray[$i][15])
										if StringLeft($winoutput,4) == "Wait" Then _MoveListItem($windowtitlearray[$i][1],2)
										if StringLeft($winoutput,7) == "Hunting" Then _MoveListItem($windowtitlearray[$i][1],2)
										if StringLeft($winoutput,5) == "lobby" Then _MoveListItem($windowtitlearray[$i][1],2)
										if StringLeft($winoutput,6) == "ingame" Then _MoveListItem($windowtitlearray[$i][1],2)
										if StringLeft($winoutput,3) == "FTJ" Then _MoveListItem($windowtitlearray[$i][1],2)
										if StringLeft($winoutput,8) == "Creating" Then _MoveListItem($windowtitlearray[$i][1],2)
									EndIf
								EndIf
							EndIf
						EndIf

						ExitLoop
					EndIf
				Next
			EndIf
		EndIf
	Next

	$groupdetection = $groupdetection + 1
	if $groupdetection >= 8 Then ;check only every 2 seconds
		$groupdetection = 0
		Local $grouparray[21][256]
		for $i = 1 to (UBound($windowtitlearray) -1)
			if $windowtitlearray[$i][4] == 3 Then ;Check if in third tab
				$grouparray[$windowtitlearray[$i][15]][StringReplace(StringRight($windowtitlearray[$i][7],3),".","")] = $grouparray[$windowtitlearray[$i][15]][StringReplace(StringRight($windowtitlearray[$i][7],3),".","")] + 1
				if $grouparray[$windowtitlearray[$i][15]][StringReplace(StringRight($windowtitlearray[$i][7],3),".","")] >= 4 Then ;we don't want to go over 4 games per ip or we will lose games
					$grouparray[$windowtitlearray[$i][15]][StringReplace(StringRight($windowtitlearray[$i][7],3),".","")] = -100 ;make sure we don't get the same group on the same pass
					for $j = 1 to (UBound($windowtitlearray) -1)
						if $windowtitlearray[$j][4] == 2 Then ;Check if in second tab
							if $windowtitlearray[$j][15] == $windowtitlearray[$i][15] Then
								if Not (($windowtitlearray[$j][5] == "Paused") Or (StringLeft($windowtitlearray[$j][5],4) == "Wait")) Then
									_output($windowtitlearray[$j][2],"pause")
								EndIf
							EndIf
						EndIf
					Next
				EndIf
			EndIf
		Next


		Local $grouparray[21][256]
		for $i = 1 to (UBound($windowtitlearray) -1)
			if $windowtitlearray[$i][20] == 1 Then ;user only wants to find 1 game per ip
				if $windowtitlearray[$i][4] == 3 Then ;Check if in third tab
					$grouparray[$windowtitlearray[$i][15]][StringReplace(StringRight($windowtitlearray[$i][7],3),".","")] = $grouparray[$windowtitlearray[$i][15]][StringReplace(StringRight($windowtitlearray[$i][7],3),".","")] + 1
					if $grouparray[$windowtitlearray[$i][15]][StringReplace(StringRight($windowtitlearray[$i][7],3),".","")] >= 1 Then ;we don't want to go over 4 games per ip or we will lose games
						$grouparray[$windowtitlearray[$i][15]][StringReplace(StringRight($windowtitlearray[$i][7],3),".","")] = -100 ;make sure we don't get the same group on the same pass
						for $j = 1 to (UBound($windowtitlearray) -1)
							if $windowtitlearray[$j][4] == 2 Then ;Check if in second tab
								if $windowtitlearray[$j][15] == $windowtitlearray[$i][15] Then ;check if the same group

									$SplitIPs = StringSplit(StringStripWS($windowtitlearray[$j][9], 8), ",")  ;; breaks IPs into separate array entries
									$IPList = ""
									$removedip = 0
									For $r = 1 To UBound($SplitIPs) - 1
										if $SplitIPs[$r] == StringReplace(StringRight($windowtitlearray[$i][7],3),".","") Then
											$removedip = 1 ;don't add this ip to the new hunting ip array
										Else
											If $IPList == "" Then
												$IPList = $SplitIPs[$r]  ;; init to first split IP
											Else
												$IPList = $IPList & ", " & $SplitIPs[$r]
											EndIf
										EndIf
									Next

									if $removedip == 1 Then
										if UBound($SplitIPs) > 1 Then ;make sure there will be at least 1 ip left to hunt
											$windowtitlearray[$j][9] = $IPList
											_output($windowtitlearray[$j][2],"chgip:" & $windowtitlearray[$j][9])
										EndIf
									EndIf

								EndIf
							EndIf
						Next
					EndIf
				EndIf
			EndIf
		Next
	EndIf
EndFunc
#EndRegion
